/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.options;

import com.google.common.collect.Multimap;
import java.util.Map;
import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.openstack.swift.v1.binders.BindMetadataToHeaders;

public class UpdateContainerOptions
extends BaseHttpRequestOptions {
    public static final UpdateContainerOptions NONE = new UpdateContainerOptions();
    private static final BindMetadataToHeaders bindMetadataToHeaders = new BindMetadataToHeaders("X-Container-Meta-");

    public UpdateContainerOptions headers(Multimap<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public UpdateContainerOptions metadata(Map<String, String> metadata) {
        this.headers.putAll(bindMetadataToHeaders.toHeaders(metadata));
        return this;
    }

    public UpdateContainerOptions anybodyRead() {
        this.headers.put("X-Container-Read", ".r:*,.rlistings");
        return this;
    }

    public UpdateContainerOptions versionsLocation(String containerName) {
        this.headers.put("X-Versions-Location", containerName);
        return this;
    }

    public static class Builder {
        public static UpdateContainerOptions anybodyRead() {
            UpdateContainerOptions options = new UpdateContainerOptions();
            return options.anybodyRead();
        }

        public static UpdateContainerOptions headers(Multimap<String, String> headers) {
            UpdateContainerOptions options = new UpdateContainerOptions();
            return options.headers(headers);
        }

        public static UpdateContainerOptions metadata(Map<String, String> metadata) {
            UpdateContainerOptions options = new UpdateContainerOptions();
            return options.metadata(metadata);
        }

        public static UpdateContainerOptions versionsLocation(String containerName) {
            UpdateContainerOptions options = new UpdateContainerOptions();
            return options.versionsLocation(containerName);
        }
    }
}

