/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListContainerOptions
extends BaseHttpRequestOptions {
    public static final ListContainerOptions NONE = new ListContainerOptions();

    public ListContainerOptions limit(int limit) {
        Preconditions.checkState(limit >= 0, "limit must be >= 0");
        Preconditions.checkState(limit <= 10000, "limit must be <= 10000");
        this.queryParameters.put("limit", Integer.toString(limit));
        return this;
    }

    public ListContainerOptions marker(String marker) {
        this.queryParameters.put("marker", Preconditions.checkNotNull(marker, "marker"));
        return this;
    }

    public ListContainerOptions endMarker(String endMarker) {
        this.queryParameters.put("end_marker", Preconditions.checkNotNull(endMarker, "endMarker"));
        return this;
    }

    public ListContainerOptions prefix(String prefix) {
        this.queryParameters.put("prefix", Preconditions.checkNotNull(prefix, "prefix"));
        return this;
    }

    public ListContainerOptions delimiter(char delimiter) {
        this.queryParameters.put("delimiter", Character.toString(delimiter));
        return this;
    }

    public ListContainerOptions path(String path) {
        this.queryParameters.put("path", Preconditions.checkNotNull(path, "path"));
        return this;
    }

    public static class Builder {
        public static ListContainerOptions limit(int limit) {
            ListContainerOptions options = new ListContainerOptions();
            return options.limit(limit);
        }

        public static ListContainerOptions marker(String marker) {
            ListContainerOptions options = new ListContainerOptions();
            return options.marker(marker);
        }

        public static ListContainerOptions endMarker(String endMarker) {
            ListContainerOptions options = new ListContainerOptions();
            return options.endMarker(endMarker);
        }

        public static ListContainerOptions prefix(String prefix) {
            ListContainerOptions options = new ListContainerOptions();
            return options.prefix(prefix);
        }

        public static ListContainerOptions delimiter(char delimiter) {
            ListContainerOptions options = new ListContainerOptions();
            return options.delimiter(delimiter);
        }

        public static ListContainerOptions path(String path) {
            ListContainerOptions options = new ListContainerOptions();
            return options.path(path);
        }
    }
}

