/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.Uris;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.openstack.swift.v1.domain.Container;
import org.jclouds.openstack.swift.v1.domain.ObjectList;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.functions.ParseContainerFromHeaders;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Strings2;

public class ParseObjectListFromResponse
implements Function<HttpResponse, ObjectList>,
InvocationContext<ParseObjectListFromResponse> {
    public static final String SUBDIR_ETAG = "deadbeef";
    private final ParseJson<List<InternalObject>> json;
    private final ParseContainerFromHeaders parseContainer;
    private ToSwiftObject toSwiftObject;

    @Inject
    ParseObjectListFromResponse(ParseJson<List<InternalObject>> json, ParseContainerFromHeaders parseContainer) {
        this.json = json;
        this.parseContainer = parseContainer;
    }

    @Override
    public ObjectList apply(HttpResponse from) {
        List<SwiftObject> objects = Lists.transform(this.json.apply(from), this.toSwiftObject);
        Container container = this.parseContainer.apply(from);
        return ObjectList.create(objects, container);
    }

    @Override
    public ParseObjectListFromResponse setContext(HttpRequest request) {
        this.parseContainer.name = ((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request)).getCaller().get().getArgs().get(1).toString();
        String containerUri = request.getEndpoint().toString();
        int queryIndex = containerUri.indexOf(63);
        if (queryIndex != -1) {
            containerUri = containerUri.substring(0, queryIndex);
        }
        this.toSwiftObject = new ToSwiftObject(containerUri);
        return this;
    }

    private static Payload payload(long bytes, String hash, String contentType, Date expires) {
        ByteSourcePayload payload = Payloads.newByteSourcePayload(ByteSource.empty());
        payload.getContentMetadata().setContentLength(bytes);
        payload.getContentMetadata().setContentType(contentType);
        payload.getContentMetadata().setExpires(expires);
        if (hash != null) {
            payload.getContentMetadata().setContentMD5(HashCode.fromBytes(BaseEncoding.base16().lowerCase().decode(hash)));
        }
        return payload;
    }

    static class ToSwiftObject
    implements Function<InternalObject, SwiftObject> {
        private final String containerUri;

        ToSwiftObject(String containerUri) {
            this.containerUri = containerUri;
        }

        @Override
        public SwiftObject apply(InternalObject input) {
            if (input.subdir != null) {
                return SwiftObject.builder().uri(Uris.uriBuilder(this.containerUri).clearQuery().appendPath(Strings2.urlEncode(input.subdir, new char[0])).build()).name(input.subdir).etag(ParseObjectListFromResponse.SUBDIR_ETAG).payload(ParseObjectListFromResponse.payload(input.bytes, input.hash, "application/directory", input.expires)).lastModified(new Date(0L)).build();
            }
            String name = Strings.nullToEmpty(input.name);
            String etag = Strings.nullToEmpty(input.hash);
            Date lastModified = input.last_modified == null ? new Date() : input.last_modified;
            return SwiftObject.builder().uri(Uris.uriBuilder(this.containerUri).clearQuery().appendPath(Strings2.urlEncode(input.name, new char[0])).build()).name(name).etag(etag).payload(ParseObjectListFromResponse.payload(input.bytes, etag, input.content_type, input.expires)).lastModified(lastModified).build();
        }
    }

    private static final class InternalObject {
        String name;
        String hash;
        String subdir;
        long bytes;
        String content_type;
        Date last_modified;
        Date expires;

        private InternalObject() {
        }
    }
}

