/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.openstack.swift.v1.domain.Container;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;

public class ToBlobMetadata
implements Function<SwiftObject, MutableBlobMetadata> {
    private final Container container;

    public ToBlobMetadata(Container container) {
        this.container = Preconditions.checkNotNull(container, "container");
    }

    @Override
    public MutableBlobMetadata apply(SwiftObject from) {
        if (from == null) {
            return null;
        }
        MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
        to.setContainer(this.container.getName());
        if (this.container.getAnybodyRead().isPresent()) {
            to.setPublicUri(from.getUri());
        }
        String eTag = from.getETag();
        to.setUri(from.getUri());
        to.setETag(eTag);
        to.setName(from.getName());
        to.setLastModified(from.getLastModified());
        to.setContentMetadata(from.getPayload().getContentMetadata());
        to.getContentMetadata().setContentMD5(from.getPayload().getContentMetadata().getContentMD5AsHashCode());
        to.getContentMetadata().setExpires(from.getPayload().getContentMetadata().getExpires());
        to.setUserMetadata(from.getMetadata());
        if (eTag != null && eTag.equals("deadbeef")) {
            to.setType(StorageType.FOLDER);
        } else {
            to.setType(StorageType.BLOB);
        }
        to.setSize(from.getPayload().getContentMetadata().getContentLength());
        to.setTier(Tier.STANDARD);
        return to;
    }

    public String toString() {
        return "ObjectToBlobMetadata(" + this.container + ")";
    }
}

