/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.internal.GsonWrapper;

@Singleton
public class OnlyMetadataValueOrNull
implements Function<HttpResponse, String> {
    private final ParseJson<Wrapper> parser;

    @Inject
    public OnlyMetadataValueOrNull(GsonWrapper gsonView) {
        this.parser = new ParseJson<Wrapper>(Preconditions.checkNotNull(gsonView, "gsonView"), new TypeLiteral<Wrapper>(){});
    }

    @Override
    public String apply(HttpResponse response) {
        Preconditions.checkNotNull(response, "response");
        return this.parser.apply(response).get();
    }

    private static class Wrapper
    implements Supplier<String> {
        private Map<String, String> metadata;

        private Wrapper() {
        }

        @Override
        public String get() {
            return this.metadata == null ? null : (String)Iterables.get(this.metadata.values(), 0, null);
        }
    }
}

