/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain.regionscoped;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class RegionAndId {
    protected final String regionId;
    protected final String id;

    public static RegionAndId fromSlashEncoded(String id) {
        Iterable<String> parts = Splitter.on('/').split(Preconditions.checkNotNull(id, "id"));
        Preconditions.checkArgument(Iterables.size(parts) == 2, "id must be in format regionId/id");
        return new RegionAndId(Iterables.get(parts, 0), Iterables.get(parts, 1));
    }

    public static RegionAndId fromRegionAndId(String regionId, String id) {
        return new RegionAndId(regionId, id);
    }

    private static String slashEncodeRegionAndId(String regionId, String id) {
        return Preconditions.checkNotNull(regionId, "regionId") + "/" + Preconditions.checkNotNull(id, "id");
    }

    public String slashEncode() {
        return RegionAndId.slashEncodeRegionAndId(this.regionId, this.id);
    }

    protected RegionAndId(String regionId, String id) {
        this.regionId = Preconditions.checkNotNull(regionId, "regionId");
        this.id = Preconditions.checkNotNull(id, "id");
    }

    public String getRegion() {
        return this.regionId;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode(this.regionId, this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionAndId other = (RegionAndId)obj;
        return Objects.equal(this.regionId, other.regionId) && Objects.equal(this.id, other.id);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("regionId", this.regionId).add("id", this.id);
    }

    public String toString() {
        return this.string().toString();
    }
}

