/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Map;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class VolumeType {
    private final String id;
    private final String name;
    @Named(value="created_at")
    private final Date created;
    @Named(value="updated_at")
    private final Optional<Date> updated;
    @Named(value="extra_specs")
    private final Map<String, String> extraSpecs;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVolumeType(this);
    }

    @ConstructorProperties(value={"id", "name", "created_at", "updated_at", "extra_specs"})
    protected VolumeType(String id, String name, Date created, @Nullable Date updated, Map<String, String> extraSpecs) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Preconditions.checkNotNull(name, "name");
        this.created = Preconditions.checkNotNull(created, "created");
        this.updated = Optional.fromNullable(updated);
        this.extraSpecs = ImmutableMap.copyOf(Preconditions.checkNotNull(extraSpecs, "extraSpecs"));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreated() {
        return this.created;
    }

    public Optional<Date> getUpdated() {
        return this.updated;
    }

    public Map<String, String> getExtraSpecs() {
        return this.extraSpecs;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.created, this.updated, this.extraSpecs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VolumeType that = (VolumeType)VolumeType.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.created, that.created) && Objects.equal(this.updated, that.updated) && Objects.equal(this.extraSpecs, that.extraSpecs);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.name).add("created", this.created).add("updated", this.updated).add("extraSpecs", this.extraSpecs);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected Date created;
        protected Date updated;
        protected Map<String, String> extraSpecs = ImmutableMap.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T updated(Date updated) {
            this.updated = updated;
            return this.self();
        }

        public T extraSpecs(Map<String, String> extraSpecs) {
            this.extraSpecs = ImmutableMap.copyOf(Preconditions.checkNotNull(extraSpecs, "extraSpecs"));
            return this.self();
        }

        public VolumeType build() {
            return new VolumeType(this.id, this.name, this.created, this.updated, this.extraSpecs);
        }

        public T fromVolumeType(VolumeType in) {
            return ((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).created(in.getCreated())).updated(in.getUpdated().orNull())).extraSpecs(in.getExtraSpecs());
        }
    }
}

