/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.openstack.nova.v2_0.domain.FixedIP;
import org.jclouds.openstack.nova.v2_0.domain.PortState;

public class InterfaceAttachment {
    @Named(value="net_id")
    private String networkId;
    @Named(value="port_id")
    private String portId;
    @Named(value="port_state")
    private PortState portState;
    @Named(value="mac_addr")
    private String macAddress;
    @Named(value="fixed_ips")
    private ImmutableSet<FixedIP> fixedIps;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromInterfaceAttachment(this);
    }

    @ConstructorProperties(value={"net_id", "port_id", "port_state", "mac_addr", "fixed_ips"})
    protected InterfaceAttachment(String networkId, String portId, PortState portState, String macAddress, ImmutableSet<FixedIP> fixedIps) {
        this.networkId = networkId;
        this.portId = Preconditions.checkNotNull(portId, "portId");
        this.portState = portState;
        this.macAddress = macAddress;
        this.fixedIps = fixedIps;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public String getPortId() {
        return this.portId;
    }

    public PortState getPortState() {
        return this.portState;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public ImmutableSet<FixedIP> getFixedIps() {
        return this.fixedIps;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.networkId, this.portId, this.portState, this.macAddress, this.fixedIps});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InterfaceAttachment that = (InterfaceAttachment)InterfaceAttachment.class.cast(obj);
        return Objects.equal(this.networkId, that.networkId) && Objects.equal(this.portId, that.portId) && Objects.equal((Object)this.portState, (Object)that.portState) && Objects.equal(this.macAddress, that.macAddress) && Objects.equal(this.fixedIps, that.fixedIps);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("networkId", this.networkId).add("portId", this.portId).add("portState", (Object)this.portState).add("macAddress", this.macAddress).add("fixedIps", this.fixedIps);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String networkId;
        private String portId;
        private PortState portState;
        private String macAddress;
        private ImmutableSet<FixedIP> fixedIps;

        protected abstract T self();

        public T networkId(String networkId) {
            this.networkId = networkId;
            return this.self();
        }

        public T portId(String portId) {
            this.portId = portId;
            return this.self();
        }

        public T portState(PortState portState) {
            this.portState = portState;
            return this.self();
        }

        public T macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this.self();
        }

        public T fixedIps(ImmutableSet<FixedIP> fixedIps) {
            this.fixedIps = fixedIps;
            return this.self();
        }

        public InterfaceAttachment build() {
            return new InterfaceAttachment(this.networkId, this.portId, this.portState, this.macAddress, this.fixedIps);
        }

        public T fromInterfaceAttachment(InterfaceAttachment in) {
            return ((Builder)((Builder)((Builder)((Builder)this.networkId(in.getNetworkId())).portId(in.getPortId())).portState(in.getPortState())).macAddress(in.getMacAddress())).fixedIps(in.getFixedIps());
        }
    }
}

