/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIP;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIpForServer;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.extensions.FloatingIPApi;

@Singleton
public class LoadFloatingIpsForInstance
extends CacheLoader<RegionAndId, Iterable<? extends FloatingIpForServer>> {
    private final NovaApi api;

    @Inject
    public LoadFloatingIpsForInstance(NovaApi api) {
        this.api = api;
    }

    @Override
    public Iterable<? extends FloatingIpForServer> load(final RegionAndId key) throws Exception {
        String region = key.getRegion();
        Optional<FloatingIPApi> ipApiOptional = this.api.getFloatingIPApi(region);
        if (ipApiOptional.isPresent()) {
            return ipApiOptional.get().list().filter(new Predicate<FloatingIP>(){

                @Override
                public boolean apply(FloatingIP input) {
                    return key.getId().equals(input.getInstanceId());
                }
            }).transform(new Function<FloatingIP, FloatingIpForServer>(){

                @Override
                public FloatingIpForServer apply(FloatingIP input) {
                    return FloatingIpForServer.create(key, input.getId(), input.getIp());
                }
            });
        }
        return ImmutableSet.of();
    }
}

