/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.NovaComputeService;
import org.jclouds.openstack.nova.v2_0.compute.NovaComputeServiceAdapter;
import org.jclouds.openstack.nova.v2_0.compute.extensions.NeutronSecurityGroupExtension;
import org.jclouds.openstack.nova.v2_0.compute.extensions.NovaImageExtension;
import org.jclouds.openstack.nova.v2_0.compute.extensions.NovaSecurityGroupExtension;
import org.jclouds.openstack.nova.v2_0.compute.functions.CleanupResources;
import org.jclouds.openstack.nova.v2_0.compute.functions.CreateSecurityGroupIfNeeded;
import org.jclouds.openstack.nova.v2_0.compute.functions.FlavorInRegionToHardware;
import org.jclouds.openstack.nova.v2_0.compute.functions.ImageInRegionToImage;
import org.jclouds.openstack.nova.v2_0.compute.functions.ImageToOperatingSystem;
import org.jclouds.openstack.nova.v2_0.compute.functions.NeutronSecurityGroupToSecurityGroup;
import org.jclouds.openstack.nova.v2_0.compute.functions.NovaSecurityGroupInRegionToSecurityGroup;
import org.jclouds.openstack.nova.v2_0.compute.functions.NovaSecurityGroupToSecurityGroup;
import org.jclouds.openstack.nova.v2_0.compute.functions.OrphanedGroupsByRegionId;
import org.jclouds.openstack.nova.v2_0.compute.functions.ServerInRegionToNodeMetadata;
import org.jclouds.openstack.nova.v2_0.compute.loaders.FindSecurityGroupOrCreate;
import org.jclouds.openstack.nova.v2_0.compute.loaders.LoadFloatingIpsForInstance;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.compute.strategy.ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIpForServer;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.FlavorInRegion;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.ImageInRegion;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.ServerInRegion;
import org.jclouds.util.Predicates2;

public class NovaComputeServiceContextModule
extends ComputeServiceAdapterContextModule<ServerInRegion, FlavorInRegion, ImageInRegion, Location> {
    @VisibleForTesting
    public static final Map<Server.Status, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put(Server.Status.ACTIVE, NodeMetadata.Status.RUNNING).put(Server.Status.BUILD, NodeMetadata.Status.PENDING).put(Server.Status.DELETED, NodeMetadata.Status.TERMINATED).put(Server.Status.ERROR, NodeMetadata.Status.ERROR).put(Server.Status.HARD_REBOOT, NodeMetadata.Status.PENDING).put(Server.Status.MIGRATING, NodeMetadata.Status.PENDING).put(Server.Status.PASSWORD, NodeMetadata.Status.PENDING).put(Server.Status.PAUSED, NodeMetadata.Status.SUSPENDED).put(Server.Status.REBOOT, NodeMetadata.Status.PENDING).put(Server.Status.REBUILD, NodeMetadata.Status.PENDING).put(Server.Status.RESCUE, NodeMetadata.Status.PENDING).put(Server.Status.RESIZE, NodeMetadata.Status.PENDING).put(Server.Status.REVERT_RESIZE, NodeMetadata.Status.PENDING).put(Server.Status.SHELVED, NodeMetadata.Status.SUSPENDED).put(Server.Status.SHELVED_OFFLOADED, NodeMetadata.Status.SUSPENDED).put(Server.Status.SHUTOFF, NodeMetadata.Status.SUSPENDED).put(Server.Status.SOFT_DELETED, NodeMetadata.Status.TERMINATED).put(Server.Status.STOPPED, NodeMetadata.Status.SUSPENDED).put(Server.Status.SUSPENDED, NodeMetadata.Status.SUSPENDED).put(Server.Status.UNKNOWN, NodeMetadata.Status.UNRECOGNIZED).put(Server.Status.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).put(Server.Status.VERIFY_RESIZE, NodeMetadata.Status.PENDING).build();
    @VisibleForTesting
    public static final Map<Image.Status, Image.Status> toPortableImageStatus = ImmutableMap.builder().put(Image.Status.ACTIVE, Image.Status.AVAILABLE).put(Image.Status.SAVING, Image.Status.PENDING).put(Image.Status.DELETED, Image.Status.DELETED).put(Image.Status.ERROR, Image.Status.ERROR).put(Image.Status.UNKNOWN, Image.Status.UNRECOGNIZED).put(Image.Status.UNRECOGNIZED, Image.Status.UNRECOGNIZED).build();

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<ComputeServiceAdapter<ServerInRegion, FlavorInRegion, ImageInRegion, Location>>(){}).to(NovaComputeServiceAdapter.class);
        this.bind(ComputeService.class).to(NovaComputeService.class);
        this.bind(new TypeLiteral<Function<ServerInRegion, NodeMetadata>>(){}).to(ServerInRegionToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<SecurityGroupInRegion, SecurityGroup>>(){}).to(NovaSecurityGroupInRegionToSecurityGroup.class);
        this.bind(new TypeLiteral<Function<Set<? extends NodeMetadata>, Multimap<String, String>>>(){}).to(OrphanedGroupsByRegionId.class);
        this.bind(new TypeLiteral<Function<ImageInRegion, Image>>(){}).to(ImageInRegionToImage.class);
        this.bind(new TypeLiteral<Function<org.jclouds.openstack.nova.v2_0.domain.Image, OperatingSystem>>(){}).to(ImageToOperatingSystem.class);
        this.bind(new TypeLiteral<Function<FlavorInRegion, Hardware>>(){}).to(FlavorInRegionToHardware.class);
        this.bind(new TypeLiteral<Function<Location, Location>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind(TemplateOptions.class).to(NovaTemplateOptions.class);
        this.bind(new TypeLiteral<CacheLoader<RegionAndId, Iterable<? extends FloatingIpForServer>>>(){}).annotatedWith(Names.named("FLOATINGIP")).to(LoadFloatingIpsForInstance.class);
        this.bind(new TypeLiteral<Function<RegionSecurityGroupNameAndPorts, SecurityGroup>>(){}).to(CreateSecurityGroupIfNeeded.class);
        this.bind(new TypeLiteral<CacheLoader<RegionAndName, SecurityGroup>>(){}).to(FindSecurityGroupOrCreate.class);
        this.bind(CreateNodesWithGroupEncodedIntoNameThenAddToSet.class).to(ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet.class);
        this.bind(new TypeLiteral<ImageExtension>(){}).to(NovaImageExtension.class);
        this.bind(new TypeLiteral<Function<NodeMetadata, Boolean>>(){}).to(CleanupResources.class);
        this.install(new FactoryModuleBuilder().build(NeutronSecurityGroupToSecurityGroup.Factory.class));
        this.install(new FactoryModuleBuilder().build(NovaSecurityGroupToSecurityGroup.Factory.class));
        this.bind(new TypeLiteral<SecurityGroupExtension>(){}).toProvider(SecurityGroupExtensionProvider.class);
    }

    @Override
    protected TemplateOptions provideTemplateOptions(Injector injector, TemplateOptions options) {
        return options.as(NovaTemplateOptions.class).autoAssignFloatingIp(injector.getInstance(Key.get(Boolean.TYPE, (Annotation)Names.named("jclouds.openstack-nova.auto-create-floating-ips")))).generateKeyPair(injector.getInstance(Key.get(Boolean.TYPE, (Annotation)Names.named("jclouds.openstack-nova.auto-generate-keypairs"))));
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-running")
    protected Predicate<RegionAndId> provideServerRunningPredicate(NovaApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry(new ServerInStatusPredicate(api, Server.Status.ACTIVE), timeouts.nodeRunning, pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-terminated")
    protected Predicate<RegionAndId> provideServerTerminatedPredicate(NovaApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry(new ServerTerminatedPredicate(api), timeouts.nodeTerminated, pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @javax.inject.Named(value="FLOATINGIP")
    protected final LoadingCache<RegionAndId, Iterable<? extends FloatingIpForServer>> instanceToFloatingIps(@javax.inject.Named(value="FLOATINGIP") CacheLoader<RegionAndId, Iterable<? extends FloatingIpForServer>> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    protected final LoadingCache<RegionAndName, SecurityGroup> securityGroupMap(CacheLoader<RegionAndName, SecurityGroup> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Override
    protected Map<OsFamily, LoginCredentials> osFamilyToCredentials(Injector injector) {
        return ImmutableMap.of(OsFamily.WINDOWS, LoginCredentials.builder().user("Administrator").build(), OsFamily.UBUNTU, LoginCredentials.builder().user("ubuntu").build());
    }

    @Provides
    @Singleton
    protected final Supplier<Map<String, Location>> createLocationIndexedById(@Memoized Supplier<Set<? extends Location>> locations) {
        return Suppliers.compose(new Function<Set<? extends Location>, Map<String, Location>>(){

            @Override
            public Map<String, Location> apply(Set<? extends Location> arg0) {
                Set<? extends Location> locations = arg0;
                return Maps.uniqueIndex(locations, new Function<Location, String>(){

                    @Override
                    public String apply(Location arg0) {
                        return arg0.getId();
                    }
                });
            }
        }, locations);
    }

    @Singleton
    @Provides
    protected final Map<Server.Status, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }

    @Singleton
    @Provides
    protected final Map<Image.Status, Image.Status> toPortableImageStatus() {
        return toPortableImageStatus;
    }

    @VisibleForTesting
    static class ServerTerminatedPredicate
    implements Predicate<RegionAndId> {
        private final NovaApi api;

        public ServerTerminatedPredicate(NovaApi api) {
            this.api = Preconditions.checkNotNull(api, "api must not be null");
        }

        @Override
        public boolean apply(RegionAndId regionAndId) {
            Preconditions.checkNotNull(regionAndId, "serverId");
            Server server = this.api.getServerApi(regionAndId.getRegion()).get(regionAndId.getId());
            return server == null;
        }
    }

    @VisibleForTesting
    static class ServerInStatusPredicate
    implements Predicate<RegionAndId> {
        private final NovaApi api;
        private final Server.Status status;

        public ServerInStatusPredicate(NovaApi api, Server.Status status) {
            this.api = Preconditions.checkNotNull(api, "api must not be null");
            this.status = Preconditions.checkNotNull(status, "status must not be null");
        }

        @Override
        public boolean apply(RegionAndId regionAndId) {
            Preconditions.checkNotNull(regionAndId, "serverId");
            Server server = this.api.getServerApi(regionAndId.getRegion()).get(regionAndId.getId());
            if (server == null) {
                throw new IllegalStateException(String.format("Server %s not found.", regionAndId.getId()));
            }
            return this.status.equals((Object)server.getStatus());
        }
    }

    @Singleton
    public static class SecurityGroupExtensionProvider
    implements Provider<SecurityGroupExtension> {
        @Inject(optional=true)
        @javax.inject.Named(value="openstack-neutron")
        protected Supplier<Context> neutronApiContextSupplier;
        private final NeutronSecurityGroupExtension neutronSecurityGroupExtension;
        private final NovaSecurityGroupExtension novaSecurityGroupExtension;

        @Inject
        SecurityGroupExtensionProvider(NeutronSecurityGroupExtension neutronSecurityGroupExtension, NovaSecurityGroupExtension novaSecurityGroupExtension) {
            this.neutronSecurityGroupExtension = neutronSecurityGroupExtension;
            this.novaSecurityGroupExtension = novaSecurityGroupExtension;
        }

        @Override
        public SecurityGroupExtension get() {
            return this.neutronApiContextSupplier != null ? this.neutronSecurityGroupExtension : this.novaSecurityGroupExtension;
        }
    }
}

