/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.openstack.keystone.auth.config.AuthenticationModule;
import org.jclouds.openstack.keystone.catalog.config.ServiceCatalogModule;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.config.NovaComputeServiceContextModule;
import org.jclouds.openstack.nova.v2_0.config.NovaHttpApiModule;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

public class NovaApiMetadata
extends BaseHttpApiMetadata<NovaApi> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata(this);
    }

    public NovaApiMetadata() {
        this(new Builder());
    }

    protected NovaApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.ssh.max-retries", "7");
        properties.setProperty("jclouds.ssh.retry-auth", "true");
        properties.setProperty("jclouds.keystone.service-type", "compute");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        properties.setProperty("jclouds.keystone.version", "2");
        properties.setProperty("jclouds.openstack-nova.auto-create-floating-ips", "false");
        properties.setProperty("jclouds.openstack-nova.auto-generate-keypairs", "false");
        properties.setProperty("jclouds.openstack-nova.timeout.securitygroup-present", "500");
        properties.setProperty("jclouds.session-interval", "1800");
        properties.put("jclouds.template", "osFamily=UBUNTU,os64Bit=true,osVersionMatches=16.*");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<NovaApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("openstack-nova")).name("OpenStack Nova Diablo+ API")).identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant")).credentialName("${password}")).endpointName("Keystone base url ending in /v2.0/")).documentation(URI.create("http://api.openstack.org/"))).version("2")).defaultEndpoint("http://localhost:5000/v2.0/")).defaultProperties(NovaApiMetadata.defaultProperties())).view(Reflection2.typeToken(ComputeServiceContext.class))).defaultModules((Set)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(AuthenticationModule.class)).add(ServiceCatalogModule.class)).add(ServiceCatalogModule.RegionModule.class)).add(NovaParserModule.class)).add(NovaHttpApiModule.class)).add(NovaComputeServiceContextModule.class)).build()));
        }

        @Override
        public NovaApiMetadata build() {
            return new NovaApiMetadata(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

