/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.ec2.xml;

import com.google.common.base.Supplier;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.xml.CreateVolumeResponseHandler;
import org.jclouds.location.Region;
import org.jclouds.location.Zone;

public class NovaCreateVolumeResponseHandler
extends CreateVolumeResponseHandler {
    @Inject
    protected NovaCreateVolumeResponseHandler(DateService dateService, @Region Supplier<String> defaultRegion, @Zone Supplier<Map<String, Supplier<Set<String>>>> regionToZonesSupplier, @Zone Supplier<Set<String>> zonesSupplier) {
        super(dateService, defaultRegion, regionToZonesSupplier, zonesSupplier);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("status")) {
            String statusString = this.currentText.toString().trim();
            if (statusString.contains(" ")) {
                statusString = statusString.substring(0, statusString.indexOf(32));
            }
            if (this.inAttachmentSet) {
                this.attachmentStatus = Attachment.Status.fromValue(statusString);
            } else {
                this.volumeStatus = Volume.Status.fromValue(statusString);
            }
            this.currentText.setLength(0);
        } else {
            super.endElement(uri, name, qName);
        }
    }
}

