/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.location.Region;

public class VersionAwareRegionToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier;

    @Inject
    public VersionAwareRegionToEndpoint(@Region Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier) {
        this.regionToEndpointSupplier = Preconditions.checkNotNull(regionToEndpointSupplier, "regionToEndpointSupplier");
    }

    @Override
    public URI apply(Object from) {
        Map<String, Supplier<URI>> regionToEndpoint = this.regionToEndpointSupplier.get();
        Preconditions.checkState(!regionToEndpoint.isEmpty(), "no region name to endpoint mappings configured!");
        Preconditions.checkArgument(regionToEndpoint.containsKey(from), "requested location %s, which is not in the configured locations: %s", from, regionToEndpoint);
        String uri = regionToEndpoint.get(from).get().toString();
        if (uri.endsWith("/v2.0")) {
            return URI.create(uri.substring(0, uri.length() - 5));
        }
        return regionToEndpoint.get(from).get();
    }
}

