/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain.lbaas.v1;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.HttpMethod;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.LBaaSStatus;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.PoolStatus;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.ProbeType;

public class HealthMonitor {
    @Named(value="tenant_id")
    private String tenantId;
    private ProbeType type;
    private Integer delay;
    private Integer timeout;
    @Named(value="max_retries")
    private Integer maxRetries;
    @Named(value="http_method")
    private HttpMethod httpMethod;
    @Named(value="url_path")
    private String urlPath;
    @Named(value="expected_codes")
    private String expectedCodes;
    @Named(value="admin_state_up")
    private Boolean adminStateUp;
    private String id;
    private ImmutableList<PoolStatus> pools;
    private LBaaSStatus status;
    @Named(value="status_description")
    private String statusDescription;

    @ConstructorProperties(value={"id", "tenant_id", "type", "delay", "timeout", "max_retries", "http_method", "url_path", "expected_codes", "pools", "admin_state_up", "status", "status_description"})
    private HealthMonitor(String id, String tenantId, ProbeType type, Integer delay, Integer timeout, Integer maxRetries, HttpMethod httpMethod, String urlPath, String expectedCodes, ImmutableList<PoolStatus> pools, Boolean adminStateUp, LBaaSStatus status, String statusDescription) {
        this.id = id;
        this.tenantId = tenantId;
        this.type = type;
        this.delay = delay;
        this.timeout = timeout;
        this.maxRetries = maxRetries;
        this.httpMethod = httpMethod;
        this.urlPath = urlPath;
        this.expectedCodes = expectedCodes;
        this.pools = pools;
        this.adminStateUp = adminStateUp;
        this.status = status;
        this.statusDescription = statusDescription;
    }

    private HealthMonitor() {
    }

    private HealthMonitor(HealthMonitor healthMonitor) {
        this(healthMonitor.id, healthMonitor.tenantId, healthMonitor.type, healthMonitor.delay, healthMonitor.timeout, healthMonitor.maxRetries, healthMonitor.httpMethod, healthMonitor.urlPath, healthMonitor.expectedCodes, healthMonitor.pools, healthMonitor.adminStateUp, healthMonitor.status, healthMonitor.statusDescription);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public ProbeType getType() {
        return this.type;
    }

    @Nullable
    public Integer getDelay() {
        return this.delay;
    }

    @Nullable
    public Integer getTimeout() {
        return this.timeout;
    }

    @Nullable
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Nullable
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Nullable
    public String getUrlPath() {
        return this.urlPath;
    }

    @Nullable
    public String getExpectedCodes() {
        return this.expectedCodes;
    }

    @Nullable
    public ImmutableList<PoolStatus> getPools() {
        return this.pools;
    }

    @Nullable
    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    @Nullable
    public LBaaSStatus getStatus() {
        return this.status;
    }

    @Nullable
    public String getStatusDescription() {
        return this.statusDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthMonitor that = (HealthMonitor)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.tenantId, that.tenantId) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.delay, that.delay) && Objects.equal(this.timeout, that.timeout) && Objects.equal(this.maxRetries, that.maxRetries) && Objects.equal((Object)this.httpMethod, (Object)that.httpMethod) && Objects.equal(this.urlPath, that.urlPath) && Objects.equal(this.expectedCodes, that.expectedCodes) && Objects.equal(this.pools, that.pools) && Objects.equal(this.adminStateUp, that.adminStateUp) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal(this.statusDescription, that.statusDescription);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.tenantId, this.type, this.delay, this.timeout, this.maxRetries, this.httpMethod, this.urlPath, this.expectedCodes, this.pools, this.adminStateUp, this.status, this.statusDescription});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("tenantId", this.tenantId).add("type", (Object)this.type).add("delay", this.delay).add("timeout", this.timeout).add("maxRetries", this.maxRetries).add("httpMethod", (Object)this.httpMethod).add("urlPath", this.urlPath).add("expectedCodes", this.expectedCodes).add("pools", this.pools).add("adminStateUp", this.adminStateUp).add("status", (Object)this.status).add("statusDescription", this.statusDescription).toString();
    }

    public static CreateBuilder createBuilder(ProbeType type, Integer delay, Integer timeout, Integer maxRetries) {
        return new CreateBuilder(type, delay, timeout, maxRetries);
    }

    public static UpdateBuilder updateBuilder() {
        return new UpdateBuilder();
    }

    public static class UpdateHealthMonitor
    extends HealthMonitor {
        private UpdateHealthMonitor(HealthMonitor healthMonitor) {
            super(healthMonitor);
        }
    }

    public static class CreateHealthMonitor
    extends HealthMonitor {
        private CreateHealthMonitor(HealthMonitor healthMonitor) {
            super(healthMonitor);
        }
    }

    public static class UpdateBuilder
    extends Builder<UpdateBuilder> {
        private UpdateBuilder() {
        }

        public UpdateHealthMonitor build() {
            return new UpdateHealthMonitor(this.healthMonitor);
        }

        @Override
        protected UpdateBuilder self() {
            return this;
        }
    }

    public static class CreateBuilder
    extends Builder<CreateBuilder> {
        private CreateBuilder(ProbeType type, Integer delay, Integer timeout, Integer maxRetries) {
            ((CreateBuilder)((CreateBuilder)this.type(type).delay(delay)).timeout(timeout)).maxRetries(maxRetries);
        }

        public CreateBuilder tenantId(String tenantId) {
            this.healthMonitor.tenantId = tenantId;
            return this.self();
        }

        public CreateBuilder type(ProbeType type) {
            this.healthMonitor.type = type;
            return this.self();
        }

        public CreateHealthMonitor build() {
            return new CreateHealthMonitor(this.healthMonitor);
        }

        @Override
        protected CreateBuilder self() {
            return this;
        }
    }

    private static abstract class Builder<ParameterizedBuilderType> {
        protected HealthMonitor healthMonitor = new HealthMonitor();

        private Builder() {
        }

        protected abstract ParameterizedBuilderType self();

        public ParameterizedBuilderType delay(Integer delay) {
            this.healthMonitor.delay = delay;
            return this.self();
        }

        public ParameterizedBuilderType timeout(Integer timeout) {
            this.healthMonitor.timeout = timeout;
            return this.self();
        }

        public ParameterizedBuilderType maxRetries(Integer maxRetries) {
            this.healthMonitor.maxRetries = maxRetries;
            return this.self();
        }

        public ParameterizedBuilderType httpMethod(HttpMethod httpMethod) {
            this.healthMonitor.httpMethod = httpMethod;
            return this.self();
        }

        public ParameterizedBuilderType urlPath(String urlPath) {
            this.healthMonitor.urlPath = urlPath;
            return this.self();
        }

        public ParameterizedBuilderType expectedCodes(String expectedCodes) {
            this.healthMonitor.expectedCodes = expectedCodes;
            return this.self();
        }

        public ParameterizedBuilderType adminStateUp(Boolean adminStateUp) {
            this.healthMonitor.adminStateUp = adminStateUp;
            return this.self();
        }
    }
}

