/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.neutron.v2.domain.Rule;

public class SecurityGroup {
    private String id;
    @Named(value="tenant_id")
    private String tenantId;
    private String name;
    private String description;
    @Named(value="security_group_rules")
    private ImmutableList<Rule> rules;

    @ConstructorProperties(value={"id", "tenant_id", "name", "description", "security_group_rules"})
    protected SecurityGroup(String id, String tenantId, String name, String description, ImmutableList<Rule> rules) {
        this.id = id;
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.rules = rules;
    }

    private SecurityGroup(SecurityGroup securityGroup) {
        this(securityGroup.id, securityGroup.tenantId, securityGroup.name, securityGroup.description, securityGroup.rules);
    }

    private SecurityGroup() {
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public ImmutableList<Rule> getRules() {
        return this.rules != null ? this.rules : ImmutableList.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityGroup that = (SecurityGroup)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.tenantId, that.tenantId) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description) && Objects.equal(this.rules, that.rules);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.tenantId, this.name, this.description, this.rules);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("tenantId", this.tenantId).add("name", this.name).add("description", this.description).add("securityGroupRules", this.rules).toString();
    }

    public static CreateBuilder createBuilder() {
        return new CreateBuilder();
    }

    public static class CreateSecurityGroup
    extends SecurityGroup {
        private CreateSecurityGroup(SecurityGroup securityGroup) {
            super(securityGroup);
        }
    }

    public static class CreateBuilder
    extends Builder<CreateBuilder> {
        private CreateBuilder() {
        }

        public CreateSecurityGroup build() {
            return new CreateSecurityGroup(this.securityGroup);
        }

        @Override
        protected CreateBuilder self() {
            return this;
        }
    }

    private static abstract class Builder<ParameterizedBuilderType> {
        protected SecurityGroup securityGroup = new SecurityGroup();

        private Builder() {
        }

        protected abstract ParameterizedBuilderType self();

        public ParameterizedBuilderType tenantId(String tenantId) {
            this.securityGroup.tenantId = tenantId;
            return this.self();
        }

        public ParameterizedBuilderType name(String name) {
            this.securityGroup.name = name;
            return this.self();
        }

        public ParameterizedBuilderType description(String description) {
            this.securityGroup.description = description;
            return this.self();
        }
    }
}

