/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.neutron.v2.domain.ExternalGatewayInfo;
import org.jclouds.openstack.neutron.v2.domain.NetworkStatus;

public class Router {
    private String id;
    private NetworkStatus status;
    private String name;
    @Named(value="tenant_id")
    private String tenantId;
    @Named(value="admin_state_up")
    private Boolean adminStateUp;
    @Named(value="external_gateway_info")
    private ExternalGatewayInfo externalGatewayInfo;

    @ConstructorProperties(value={"id", "status", "name", "tenant_id", "admin_state_up", "external_gateway_info"})
    private Router(String id, NetworkStatus status, String name, String tenantId, Boolean adminStateUp, ExternalGatewayInfo externalGatewayInfo) {
        this.id = id;
        this.status = status;
        this.name = name;
        this.tenantId = tenantId;
        this.adminStateUp = adminStateUp;
        this.externalGatewayInfo = externalGatewayInfo;
    }

    private Router() {
    }

    private Router(Router router) {
        this(router.id, router.status, router.name, router.tenantId, router.adminStateUp, router.externalGatewayInfo);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public NetworkStatus getStatus() {
        return this.status;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    @Nullable
    public ExternalGatewayInfo getExternalGatewayInfo() {
        return this.externalGatewayInfo;
    }

    public static CreateBuilder createBuilder() {
        return new CreateBuilder();
    }

    public static UpdateBuilder updateBuilder() {
        return new UpdateBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Router that = (Router)o;
        return Objects.equal(this.id, that.id) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal(this.name, that.name) && Objects.equal(this.tenantId, that.tenantId) && Objects.equal(this.adminStateUp, that.adminStateUp) && Objects.equal(this.externalGatewayInfo, that.externalGatewayInfo);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.status, this.name, this.tenantId, this.adminStateUp, this.externalGatewayInfo});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("status", (Object)this.status).add("name", this.name).add("tenantId", this.tenantId).add("adminStateUp", this.adminStateUp).add("externalGatewayInfo", this.externalGatewayInfo).toString();
    }

    public static class UpdateRouter
    extends Router {
        private UpdateRouter(Router router) {
            super(router);
        }
    }

    public static class CreateRouter
    extends Router {
        private CreateRouter(Router router) {
            super(router);
        }
    }

    public static class UpdateBuilder
    extends Builder<UpdateBuilder> {
        private UpdateBuilder() {
        }

        public UpdateRouter build() {
            return new UpdateRouter(this.router);
        }

        @Override
        protected UpdateBuilder self() {
            return this;
        }
    }

    public static class CreateBuilder
    extends Builder<CreateBuilder> {
        private CreateBuilder() {
        }

        public CreateRouter build() {
            return new CreateRouter(this.router);
        }

        @Override
        protected CreateBuilder self() {
            return this;
        }
    }

    private static abstract class Builder<ParameterizedBuilderType> {
        protected Router router = new Router();

        private Builder() {
        }

        protected abstract ParameterizedBuilderType self();

        public ParameterizedBuilderType name(String name) {
            this.router.name = name;
            return this.self();
        }

        public ParameterizedBuilderType tenantId(String tenantId) {
            this.router.tenantId = tenantId;
            return this.self();
        }

        public ParameterizedBuilderType adminStateUp(Boolean adminStateUp) {
            this.router.adminStateUp = adminStateUp;
            return this.self();
        }

        public ParameterizedBuilderType externalGatewayInfo(ExternalGatewayInfo externalGatewayInfo) {
            this.router.externalGatewayInfo = externalGatewayInfo;
            return this.self();
        }
    }
}

