/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class AddressPair {
    @Named(value="mac_address")
    private String macAddress;
    @Named(value="ip_address")
    private String ipAddress;

    @ConstructorProperties(value={"mac_address", "ip_address"})
    protected AddressPair(String macAddress, String ipAddress) {
        Preconditions.checkNotNull(macAddress, "mac address should not be null");
        Preconditions.checkNotNull(ipAddress, "ip should not be null");
        this.macAddress = macAddress;
        this.ipAddress = ipAddress;
    }

    private AddressPair(AddressPair addressPair) {
        this(addressPair.getMacAddress(), addressPair.getIpAddress());
    }

    private AddressPair() {
    }

    @Nullable
    public String getMacAddress() {
        return this.macAddress;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    public int hashCode() {
        return Objects.hashCode(this.macAddress, this.ipAddress);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddressPair that = (AddressPair)AddressPair.class.cast(obj);
        return Objects.equal(this.macAddress, that.macAddress) && Objects.equal(this.ipAddress, that.ipAddress);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("macAddress", this.macAddress).add("ipAddress", this.ipAddress);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder(String macAddress, String ipAddress) {
        return new Builder(macAddress, ipAddress);
    }

    public Builder toBuilder() {
        return new Builder().fromAddressPair(this);
    }

    public static class Builder {
        private AddressPair addressPair = new AddressPair();

        private Builder() {
        }

        private Builder(String macAddress, String ipAddress) {
            this.addressPair.macAddress = macAddress;
            this.addressPair.ipAddress = ipAddress;
        }

        public Builder macAddress(String macAddress) {
            this.addressPair.macAddress = macAddress;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.addressPair.ipAddress = ipAddress;
            return this;
        }

        public AddressPair build() {
            return new AddressPair(this.addressPair);
        }

        public Builder fromAddressPair(AddressPair in) {
            return this.macAddress(in.getMacAddress()).ipAddress(in.getIpAddress());
        }
    }
}

