/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.auth.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;

@Singleton
public class RetryOnRenew
implements HttpRetryHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.max-retries")
    @VisibleForTesting
    static int NUM_RETRIES = 5;
    private final LoadingCache<Credentials, AuthInfo> authenticationResponseCache;
    private final BackoffLimitedRetryHandler backoffHandler;
    private static final Cache<HttpCommand, Integer> retryCountMap = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();

    @Inject
    RetryOnRenew(LoadingCache<Credentials, AuthInfo> authenticationResponseCache, BackoffLimitedRetryHandler backoffHandler) {
        this.authenticationResponseCache = authenticationResponseCache;
        this.backoffHandler = backoffHandler;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        boolean retry = false;
        switch (response.getStatusCode()) {
            case 401: {
                Multimap<String, String> headers = command.getCurrentRequest().getHeaders();
                if (headers != null && headers.containsKey("X-Auth-User") && headers.containsKey("X-Auth-Key") && !headers.containsKey("X-Auth-Token")) {
                    retry = false;
                    break;
                }
                Integer count = retryCountMap.getIfPresent(command);
                if (count == null) {
                    this.logger.debug("invalidating authentication token - first time for %s", command);
                    retryCountMap.put(command, 1);
                    this.authenticationResponseCache.invalidateAll();
                    retry = true;
                    break;
                }
                if (count + 1 >= NUM_RETRIES) {
                    this.logger.debug("too many 401s - giving up after: %s for %s", count, command);
                    retry = false;
                    break;
                }
                this.logger.debug("invalidating authentication token - retry %s for %s", count, command);
                retryCountMap.put(command, count + 1);
                this.authenticationResponseCache.invalidateAll();
                Uninterruptibles.sleepUninterruptibly(5L, TimeUnit.SECONDS);
                retry = true;
                break;
            }
            case 408: {
                return this.backoffHandler.shouldRetryRequest(command, response);
            }
        }
        return retry;
    }
}

