/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jclouds.openstack.cinder.v1.domain.Volume;
import org.jclouds.openstack.cinder.v1.features.VolumeApi;
import org.jclouds.util.Predicates2;

public class VolumePredicates {
    public static Predicate<Volume> awaitAvailable(VolumeApi volumeApi) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(volumeApi, Volume.Status.AVAILABLE);
        return Predicates2.retry(statusPredicate, 600L, 5L, 5L, TimeUnit.SECONDS);
    }

    public static Predicate<Volume> awaitInUse(VolumeApi volumeApi) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(volumeApi, Volume.Status.IN_USE);
        return Predicates2.retry(statusPredicate, 600L, 5L, 5L, TimeUnit.SECONDS);
    }

    public static Predicate<Volume> awaitDeleted(VolumeApi volumeApi) {
        DeletedPredicate deletedPredicate = new DeletedPredicate(volumeApi);
        return Predicates2.retry(deletedPredicate, 600L, 5L, 5L, TimeUnit.SECONDS);
    }

    public static Predicate<Volume> awaitStatus(VolumeApi volumeApi, Volume.Status status, long maxWaitInSec, long periodInSec) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(volumeApi, status);
        return Predicates2.retry(statusPredicate, maxWaitInSec, periodInSec, periodInSec, TimeUnit.SECONDS);
    }

    private static class DeletedPredicate
    implements Predicate<Volume> {
        private VolumeApi volumeApi;

        public DeletedPredicate(VolumeApi volumeApi) {
            this.volumeApi = Preconditions.checkNotNull(volumeApi, "volumeApi must be defined");
        }

        @Override
        public boolean apply(Volume volume) {
            Preconditions.checkNotNull(volume, "volume must be defined");
            return this.volumeApi.get(volume.getId()) == null;
        }
    }

    private static class StatusUpdatedPredicate
    implements Predicate<Volume> {
        private VolumeApi volumeApi;
        private Volume.Status status;

        public StatusUpdatedPredicate(VolumeApi volumeApi, Volume.Status status) {
            this.volumeApi = Preconditions.checkNotNull(volumeApi, "volumeApi must be defined");
            this.status = Preconditions.checkNotNull(status, "status must be defined");
        }

        @Override
        public boolean apply(Volume volume) {
            Preconditions.checkNotNull(volume, "volume must be defined");
            Volume volumeUpdated = this.volumeApi.get(volume.getId());
            Preconditions.checkNotNull(volumeUpdated, "Volume %s not found.", volume.getId());
            return this.status.equals((Object)volumeUpdated.getStatus());
        }
    }
}

