/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class SnapshotExtendedAttributes {
    @Named(value="os-extended-snapshot-attributes:project_id")
    private final String projectId;
    private final String progress;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromExtendedAttributes(this);
    }

    @ConstructorProperties(value={"os-extended-snapshot-attributes:project_id", "os-extended-snapshot-attributes:progress"})
    protected SnapshotExtendedAttributes(@Nullable String projectId, @Nullable String progress) {
        this.projectId = projectId;
        this.progress = progress;
    }

    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    @Nullable
    public String getProgress() {
        return this.progress;
    }

    public int hashCode() {
        return Objects.hashCode(this.projectId, this.progress);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotExtendedAttributes that = (SnapshotExtendedAttributes)SnapshotExtendedAttributes.class.cast(obj);
        return Objects.equal(this.projectId, that.projectId) && Objects.equal(this.progress, that.progress);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("projectId", this.projectId).add("progress", this.progress);
    }

    public String toString() {
        return this.string().toString();
    }

    public static class Builder {
        protected String projectId;
        protected String progress;

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this.self();
        }

        public Builder progress(String progress) {
            this.progress = progress;
            return this.self();
        }

        public SnapshotExtendedAttributes build() {
            return new SnapshotExtendedAttributes(this.projectId, this.progress);
        }

        public Builder fromExtendedAttributes(SnapshotExtendedAttributes in) {
            return this.projectId(in.getProjectId()).progress(in.getProgress());
        }

        protected Builder self() {
            return this;
        }
    }
}

