/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.cinder.v1.domain.SnapshotExtendedAttributes;
import org.jclouds.openstack.cinder.v1.domain.Volume;

public class Snapshot {
    private final String id;
    @Named(value="volume_id")
    private final String volumeId;
    private final Volume.Status status;
    private final int size;
    @Named(value="created_at")
    private final Date created;
    @Named(value="display_name")
    private final String name;
    @Named(value="display_description")
    private final String description;
    private final Optional<SnapshotExtendedAttributes> extendedAttributes;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromSnapshot(this);
    }

    @ConstructorProperties(value={"id", "volume_id", "status", "size", "created_at", "display_name", "display_description", "extendedAttributes"})
    protected Snapshot(String id, String volumeId, Volume.Status status, int size, @Nullable Date created, @Nullable String name, @Nullable String description, @Nullable SnapshotExtendedAttributes extendedAttributes) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.volumeId = Preconditions.checkNotNull(volumeId, "volumeId");
        this.status = Preconditions.checkNotNull(status, "status");
        this.size = size;
        this.created = created;
        this.name = name;
        this.description = description;
        this.extendedAttributes = Optional.fromNullable(extendedAttributes);
    }

    public String getId() {
        return this.id;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public Volume.Status getStatus() {
        return this.status;
    }

    public int getSize() {
        return this.size;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Optional<SnapshotExtendedAttributes> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.volumeId, this.status, this.size, this.created, this.name, this.description, this.extendedAttributes});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Snapshot that = (Snapshot)Snapshot.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.volumeId, that.volumeId) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal(this.size, that.size) && Objects.equal(this.created, that.created) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description) && Objects.equal(this.extendedAttributes, that.extendedAttributes);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("volumeId", this.volumeId).add("status", (Object)this.status).add("size", this.size).add("created", this.created).add("name", this.name).add("description", this.description).add("extendedAttributes", this.extendedAttributes);
    }

    public String toString() {
        return this.string().toString();
    }

    public static class Builder {
        protected String id;
        protected String volumeId;
        protected Volume.Status status;
        protected int size;
        protected Date created;
        protected String name;
        protected String description;
        protected SnapshotExtendedAttributes extendedAttributes;

        public Builder id(String id) {
            this.id = id;
            return this.self();
        }

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this.self();
        }

        public Builder status(Volume.Status status) {
            this.status = status;
            return this.self();
        }

        public Builder size(int size) {
            this.size = size;
            return this.self();
        }

        public Builder created(Date created) {
            this.created = created;
            return this.self();
        }

        public Builder name(String name) {
            this.name = name;
            return this.self();
        }

        public Builder description(String description) {
            this.description = description;
            return this.self();
        }

        public Builder extendedAttributes(SnapshotExtendedAttributes extendedAttributes) {
            this.extendedAttributes = extendedAttributes;
            return this.self();
        }

        public Snapshot build() {
            return new Snapshot(this.id, this.volumeId, this.status, this.size, this.created, this.name, this.description, this.extendedAttributes);
        }

        public Builder fromSnapshot(Snapshot in) {
            return this.id(in.getId()).volumeId(in.getVolumeId()).status(in.getStatus()).size(in.getSize()).created(in.getCreated()).name(in.getName()).description(in.getDescription()).extendedAttributes(in.getExtendedAttributes().orNull());
        }

        protected Builder self() {
            return this;
        }
    }
}

