/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ohai;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.JsonBall;
import org.jclouds.ohai.Automatic;
import org.jclouds.ohai.functions.NestSlashKeys;

@Singleton
public class AutomaticSupplier
implements Supplier<Map<String, JsonBall>> {
    private final Multimap<String, Supplier<JsonBall>> autoAttrs;
    private final NestSlashKeys nester;

    @Inject
    AutomaticSupplier(@Automatic Multimap<String, Supplier<JsonBall>> autoAttrs, NestSlashKeys nester) {
        this.autoAttrs = Preconditions.checkNotNull(autoAttrs, "autoAttrs");
        this.nester = Preconditions.checkNotNull(nester, "nester");
    }

    @Override
    public Map<String, JsonBall> get() {
        return this.nester.apply(this.autoAttrs);
    }
}

