/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.filters;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.location.Provider;
import org.jclouds.oauth.v2.AuthorizationApi;
import org.jclouds.oauth.v2.config.OAuthConfigFactory;
import org.jclouds.oauth.v2.domain.ClientCredentialsAuthArgs;
import org.jclouds.oauth.v2.domain.ClientCredentialsClaims;
import org.jclouds.oauth.v2.domain.Token;
import org.jclouds.oauth.v2.filters.OAuthFilter;

public class ClientCredentialsJWTBearerTokenFlow
implements OAuthFilter {
    private static final Joiner ON_SPACE = Joiner.on(" ");
    private final Supplier<Credentials> credentialsSupplier;
    private final OAuthConfigFactory oauthConfigFactory;
    private final LoadingCache<ClientCredentialsAuthArgs, Token> tokenCache;

    @Inject
    ClientCredentialsJWTBearerTokenFlow(AuthorizeToken loader, @Named(value="jclouds.session-interval") long tokenDuration, @Provider Supplier<Credentials> credentialsSupplier, OAuthConfigFactory oauthConfigFactory) {
        this.credentialsSupplier = credentialsSupplier;
        this.oauthConfigFactory = oauthConfigFactory;
        long cacheExpirationSeconds = tokenDuration > 30L ? tokenDuration - 30L : tokenDuration;
        this.tokenCache = CacheBuilder.newBuilder().expireAfterWrite(cacheExpirationSeconds, TimeUnit.SECONDS).build(loader);
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        OAuthConfigFactory.OAuthConfig oauthConfig = this.oauthConfigFactory.forRequest(request);
        ClientCredentialsClaims claims = ClientCredentialsClaims.create(this.credentialsSupplier.get().identity, this.credentialsSupplier.get().identity, oauthConfig.audience(), -1L, -1L, null);
        ClientCredentialsAuthArgs authArgs = ClientCredentialsAuthArgs.create(this.credentialsSupplier.get().identity, claims, oauthConfig.resource(), oauthConfig.scopes().isEmpty() ? null : ON_SPACE.join(oauthConfig.scopes()));
        Token token = this.tokenCache.getUnchecked(authArgs);
        String authorization = String.format("%s %s", token.tokenType(), token.accessToken());
        return ((HttpRequest.Builder)request.toBuilder().addHeader("Authorization", authorization)).build();
    }

    static final class AuthorizeToken
    extends CacheLoader<ClientCredentialsAuthArgs, Token> {
        private final AuthorizationApi api;
        private final long tokenDuration;

        @Inject
        AuthorizeToken(AuthorizationApi api, @Named(value="jclouds.session-interval") long tokenDuration) {
            this.api = api;
            this.tokenDuration = tokenDuration;
        }

        long currentTimeSeconds() {
            return System.currentTimeMillis() / 1000L;
        }

        @Override
        public Token load(ClientCredentialsAuthArgs key) throws Exception {
            long now = this.currentTimeSeconds();
            ClientCredentialsClaims claims = ClientCredentialsClaims.create(key.claims().iss(), key.claims().sub(), key.claims().aud(), now + this.tokenDuration, now, UUID.randomUUID().toString());
            return this.api.authorize(key.clientId(), claims, key.resource(), key.scope());
        }
    }
}

