/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.config;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;

public enum CredentialType {
    BEARER_TOKEN_CREDENTIALS,
    P12_PRIVATE_KEY_CREDENTIALS,
    CLIENT_CREDENTIALS_SECRET,
    CLIENT_CREDENTIALS_P12_AND_CERTIFICATE;


    public String toString() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
    }

    public static CredentialType fromValue(String credentialType) {
        return CredentialType.valueOf(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(credentialType, "credentialType")));
    }
}

