/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.options;

import com.google.common.base.Preconditions;
import org.jclouds.googlecomputeengine.options.AutoValue_NetworkCreationOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class NetworkCreationOptions {
    public abstract String name();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract String rangeIPv4();

    @Nullable
    public abstract String gatewayIPv4();

    @Nullable
    public abstract Boolean autoCreateSubnetworks();

    @SerializedNames(value={"name", "description", "IPv4Range", "gatewayIPv4", "autoCreateSubnetworks"})
    public static NetworkCreationOptions create(String name, String description, String rangeIPv4, String gatewayIPv4, Boolean autoCreateSubnetworks) {
        return new AutoValue_NetworkCreationOptions(name, description, rangeIPv4, gatewayIPv4, autoCreateSubnetworks);
    }

    NetworkCreationOptions() {
    }

    public static class Builder {
        private String name;
        private String description;
        private String rangeIPv4;
        private String gatewayIPv4;
        private Boolean autoCreateSubnetworks;

        public Builder(String name) {
            this.name = name;
        }

        public Builder rangeIPv4(String rangeIPv4) {
            this.rangeIPv4 = rangeIPv4;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder gatewayIPv4(String gatewayIPv4) {
            this.gatewayIPv4 = gatewayIPv4;
            return this;
        }

        public Builder autoCreateSubnetworks(Boolean autoCreateSubnetworks) {
            this.autoCreateSubnetworks = autoCreateSubnetworks;
            return this;
        }

        public NetworkCreationOptions build() {
            Preconditions.checkNotNull(this.name, "NetworkCreationOptions name cannot be null");
            return NetworkCreationOptions.create(this.name, this.description, this.rangeIPv4, this.gatewayIPv4, this.autoCreateSubnetworks);
        }
    }
}

