/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.net.URI;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.binders.RouteBinder;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.Route;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.googlecomputeengine.options.RouteOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/routes")
@Consumes(value={"application/json"})
public interface RouteApi {
    @Named(value="Routes:get")
    @GET
    @Path(value="/{route}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Route get(@PathParam(value="route") String var1);

    @Named(value="Routes:delete")
    @DELETE
    @Path(value="/{route}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation delete(@PathParam(value="route") String var1);

    @Named(value="Routes:insert")
    @POST
    @Produces(value={"application/json"})
    @MapBinder(value=RouteBinder.class)
    public Operation createInNetwork(@PayloadParam(value="name") String var1, @PayloadParam(value="network") URI var2, @PayloadParam(value="options") RouteOptions var3);

    @Named(value="Routes:list")
    @GET
    public ListPage<Route> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Routes:list")
    @GET
    @Transform(value=RoutePages.class)
    public Iterator<ListPage<Route>> list();

    @Named(value="Routes:list")
    @GET
    @Transform(value=RoutePages.class)
    public Iterator<ListPage<Route>> list(ListOptions var1);

    public static final class RoutePages
    extends BaseToIteratorOfListPage<Route, RoutePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        RoutePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<Route>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<Route>>(){

                @Override
                public ListPage<Route> apply(String pageToken) {
                    return RoutePages.this.api.routes().listPage(pageToken, options);
                }
            };
        }
    }
}

