/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.googlecomputeengine.domain.Instance;

public final class InstanceToNodeMetadata
implements Function<Instance, NodeMetadata> {
    private final Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus;
    private final GroupNamingConvention nodeNamingConvention;
    private final LoadingCache<URI, Optional<Image>> diskURIToImage;
    private final Supplier<Map<URI, Hardware>> hardwares;
    private final Supplier<Map<URI, Location>> locationsByUri;

    @Inject
    InstanceToNodeMetadata(Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus, GroupNamingConvention.Factory namingConvention, LoadingCache<URI, Optional<Image>> diskURIToImage, @Memoized Supplier<Map<URI, Hardware>> hardwares, @Memoized Supplier<Map<URI, Location>> locationsByUri) {
        this.toPortableNodeStatus = toPortableNodeStatus;
        this.nodeNamingConvention = namingConvention.createWithoutPrefix();
        this.diskURIToImage = diskURIToImage;
        this.hardwares = hardwares;
        this.locationsByUri = locationsByUri;
    }

    @Override
    public NodeMetadata apply(Instance input) {
        String group = ComputeServiceUtils.groupFromMapOrName(input.metadata().asMap(), input.name(), this.nodeNamingConvention);
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        Location zone = this.locationsByUri.get().get(input.zone());
        if (zone == null) {
            throw new IllegalStateException(String.format("zone %s not present in %s", input.zone(), this.locationsByUri.get().keySet()));
        }
        URI diskSource = input.disks().get(0).source();
        Optional<Image> image = this.diskURIToImage.getUnchecked(diskSource);
        Hardware hardware = InstanceToNodeMetadata.isCustomMachineTypeURI(input.machineType()) ? InstanceToNodeMetadata.machineTypeURIToCustomHardware(input.machineType()) : this.hardwares.get().get(input.machineType());
        ((NodeMetadataBuilder)((NodeMetadataBuilder)builder.id(input.selfLink().toString()).name(input.name()).providerId(input.id()).hostname(input.name()).location(zone).imageId(image.isPresent() ? image.get().selfLink().toString() : null).hardware(hardware).status(input.status() != null ? this.toPortableNodeStatus.get((Object)input.status()) : NodeMetadata.Status.UNRECOGNIZED).tags(input.tags().items())).uri(input.selfLink()).userMetadata((Map)input.metadata().asMap())).group(group).privateAddresses(this.collectPrivateAddresses(input)).publicAddresses(this.collectPublicAddresses(input));
        return builder.build();
    }

    private List<String> collectPrivateAddresses(Instance input) {
        ImmutableList.Builder privateAddressesBuilder = ImmutableList.builder();
        for (Instance.NetworkInterface networkInterface : input.networkInterfaces()) {
            if (networkInterface.networkIP() == null) continue;
            privateAddressesBuilder.add(networkInterface.networkIP());
        }
        return privateAddressesBuilder.build();
    }

    private List<String> collectPublicAddresses(Instance input) {
        ImmutableList.Builder publicAddressesBuilder = ImmutableList.builder();
        for (Instance.NetworkInterface networkInterface : input.networkInterfaces()) {
            for (Instance.NetworkInterface.AccessConfig accessConfig : networkInterface.accessConfigs()) {
                if (accessConfig.natIP() == null) continue;
                publicAddressesBuilder.add(accessConfig.natIP());
            }
        }
        return publicAddressesBuilder.build();
    }

    public static boolean isCustomMachineTypeURI(URI machineType) {
        return machineType.toString().contains("machineTypes/custom");
    }

    public static Hardware machineTypeURIToCustomHardware(URI machineType) {
        String uri = machineType.toString();
        String values = uri.substring(uri.lastIndexOf(47) + 8);
        List<String> hardwareValues = Splitter.on('-').trimResults().splitToList(values);
        return new HardwareBuilder().id(uri).providerId(uri).processor(new Processor(Double.parseDouble(hardwareValues.get(0)), 1.0)).ram(Integer.parseInt(hardwareValues.get(1))).uri(machineType).build();
    }
}

