/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.primitives.Ints;
import org.jclouds.Fallback;
import org.jclouds.http.HttpUtils;

public final class GoogleComputeEngineFallbacks {

    public static class NullOn400or404
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable t) throws Exception {
            Boolean returnVal = HttpUtils.returnValueOnCodeOrNull(Preconditions.checkNotNull(t, "throwable"), false, Predicates.in(Ints.asList(400, 404)));
            if (returnVal != null) {
                return null;
            }
            throw Throwables.propagate(t);
        }
    }
}

