/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.handlers;

import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class GoogleCloudStorageErrorHandler
implements HttpErrorHandler {
    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        byte[] data = HttpUtils.closeClientButKeepContentStream(response);
        String message = data != null ? new String(data) : null;
        RuntimeException exception = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
        String message411 = "MissingContentLength: You must provide the Content-Length HTTP header.\n";
        String message412 = "PreconditionFailed: At least one of the pre-conditions you specified did not hold.\n";
        switch (response.getStatusCode()) {
            case 308: {
                return;
            }
            case 400: {
                if (message.indexOf("<Code>ExpiredToken</Code>") == -1) break;
                exception = new AuthorizationException(message, exception);
                break;
            }
            case 401: 
            case 403: {
                exception = new AuthorizationException(message, exception);
                break;
            }
            case 404: {
                exception = new ResourceNotFoundException(message, exception);
                break;
            }
            case 409: {
                exception = new IllegalStateException(message, exception);
                break;
            }
            case 411: {
                exception = new IllegalStateException(message411 + message, exception);
                break;
            }
            case 412: {
                exception = new IllegalStateException(message412 + message, exception);
            }
        }
        command.setException(exception);
    }
}

