/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloud.internal;

import com.google.common.base.Function;
import java.util.Iterator;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecloud.internal.AdvancingIterator;
import org.jclouds.googlecloud.internal.ListPages;
import org.jclouds.googlecloud.options.ListOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public abstract class BaseToIteratorOfListPage<T, O extends ListOptions, I extends BaseToIteratorOfListPage<T, O, I>>
implements Function<ListPage<T>, Iterator<ListPage<T>>>,
InvocationContext<I> {
    private GeneratedHttpRequest request;

    @Override
    public Iterator<ListPage<T>> apply(ListPage<T> input) {
        if (input.nextPageToken() == null) {
            return ListPages.singletonOrEmptyIterator(input);
        }
        return new AdvancingIterator<T>(input, this.fetchNextPage(ListPages.listOptions(this.request.getInvocation().getArgs())));
    }

    protected abstract Function<String, ListPage<T>> fetchNextPage(O var1);

    @Override
    public I setContext(HttpRequest request) {
        this.request = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request);
        return (I)this;
    }
}

