/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.gogrid.domain.Job;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.features.GridJobApi;
import org.jclouds.gogrid.options.GetJobListOptions;
import org.jclouds.logging.Logger;

@Singleton
public class ServerLatestJobCompleted
implements Predicate<Server> {
    protected GridJobApi jobClient;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public ServerLatestJobCompleted(GridJobApi jobClient) {
        this.jobClient = jobClient;
    }

    @Override
    public boolean apply(Server server) {
        Preconditions.checkNotNull(server, "Server must be a valid instance");
        Preconditions.checkNotNull(server.getName(), "Server must be a valid name");
        Job latestJob = Iterables.getOnlyElement(this.jobClient.getJobList(GetJobListOptions.Builder.latestJobForObjectByName(server.getName())));
        return JobState.SUCCEEDED.equals((Object)latestJob.getCurrentState());
    }
}

