/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.config;

import com.google.inject.AbstractModule;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.LocalBlobRequestSigner;
import org.jclouds.blobstore.LocalStorageStrategy;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.config.BlobStoreObjectModule;
import org.jclouds.blobstore.config.LocalBlobStore;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.filesystem.predicates.validators.FilesystemBlobKeyValidator;
import org.jclouds.filesystem.predicates.validators.FilesystemContainerNameValidator;
import org.jclouds.filesystem.predicates.validators.internal.FilesystemBlobKeyValidatorImpl;
import org.jclouds.filesystem.predicates.validators.internal.FilesystemContainerNameValidatorImpl;
import org.jclouds.filesystem.strategy.internal.FilesystemStorageStrategyImpl;
import org.jclouds.filesystem.util.Utils;
import org.jclouds.filesystem.util.internal.FileSystemBlobUtilsImpl;

public class FilesystemBlobStoreContextModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(BlobStore.class).to(LocalBlobStore.class);
        this.install(new BlobStoreObjectModule());
        if (Utils.isWindows()) {
            this.bind(ConsistencyModel.class).toInstance(ConsistencyModel.EVENTUAL);
        } else {
            this.bind(ConsistencyModel.class).toInstance(ConsistencyModel.STRICT);
        }
        this.bind(LocalStorageStrategy.class).to(FilesystemStorageStrategyImpl.class);
        this.bind(BlobUtils.class).to(FileSystemBlobUtilsImpl.class);
        this.bind(FilesystemBlobKeyValidator.class).to(FilesystemBlobKeyValidatorImpl.class);
        this.bind(FilesystemContainerNameValidator.class).to(FilesystemContainerNameValidatorImpl.class);
        this.bind(BlobRequestSigner.class).to(LocalBlobRequestSigner.class);
    }
}

