/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.PasswordData;
import org.jclouds.http.functions.ParseSax;

public class GetPasswordDataResponseHandler
extends ParseSax.HandlerWithResult<PasswordData> {
    protected final DateService dateService;
    private StringBuilder currentText = new StringBuilder();
    private PasswordData.Builder builder = PasswordData.builder();

    @Inject
    protected GetPasswordDataResponseHandler(DateService dateService) {
        this.dateService = dateService;
    }

    @Override
    public PasswordData getResult() {
        return this.builder.build();
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("instanceId")) {
            this.builder.instanceId(this.currentText.toString().trim());
        } else if (qName.equals("timestamp")) {
            this.builder.timestamp(this.dateService.iso8601DateOrSecondsDateParse(this.currentText.toString().trim()));
        } else if (qName.equals("passwordData")) {
            this.builder.passwordData(this.currentText.toString().trim());
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

