/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public final class Session {
    private final String token;
    private final String version;

    public static Session forTokenAndVersion(String token, String version) {
        return new Session(token, version);
    }

    @ConstructorProperties(value={"token", "version"})
    private Session(String token, String version) {
        this.token = Preconditions.checkNotNull(token, "token");
        this.version = Preconditions.checkNotNull(version, "version for %s", token);
    }

    public String getToken() {
        return this.token;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hashCode(this.token, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Session other = (Session)Session.class.cast(obj);
        return Objects.equal(this.token, other.token) && Objects.equal(this.version, other.version);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("token", this.token).add("version", this.version).toString();
    }
}

