/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.strategy;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.compute.options.DockerTemplateOptions;
import org.jclouds.docker.domain.Config;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.ContainerSummary;
import org.jclouds.docker.domain.HostConfig;
import org.jclouds.docker.domain.Image;
import org.jclouds.docker.domain.ImageSummary;
import org.jclouds.docker.options.AttachOptions;
import org.jclouds.docker.options.CreateImageOptions;
import org.jclouds.docker.options.ListContainerOptions;
import org.jclouds.docker.options.RemoveContainerOptions;
import org.jclouds.docker.util.DockerInputStream;
import org.jclouds.docker.util.StdStreamData;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.util.Closeables2;

@Singleton
public class DockerComputeServiceAdapter
implements ComputeServiceAdapter<Container, Hardware, Image, Location> {
    public static final String PREFIX_DOCKER_HUB_HOST = "docker.io/";
    public static final String SUFFIX_LATEST_VERSION = ":latest";
    private static final String PATTERN_IMAGE_PREFIX = "^(" + Pattern.quote("docker.io/") + ")?";
    private static final String PATTERN_IMAGE_SUFFIX = "(" + Pattern.quote(":latest") + ")?$";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final DockerApi api;

    @Inject
    public DockerComputeServiceAdapter(DockerApi api) {
        this.api = Preconditions.checkNotNull(api, "api");
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<Container> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Preconditions.checkNotNull(template, "template was null");
        TemplateOptions options = template.getOptions();
        Preconditions.checkNotNull(options, "template options was null");
        String imageId = Preconditions.checkNotNull(template.getImage().getId(), "template image id must not be null");
        String loginUser = template.getImage().getDefaultCredentials().getUser();
        String loginUserPassword = template.getImage().getDefaultCredentials().getOptionalPassword().or("password");
        DockerTemplateOptions templateOptions = (DockerTemplateOptions)DockerTemplateOptions.class.cast(options);
        Config containerConfig = null;
        Config.Builder containerConfigBuilder = templateOptions.getConfigBuilder();
        if (containerConfigBuilder == null) {
            containerConfigBuilder = Config.builder().image(imageId);
            containerConfigBuilder.entrypoint(templateOptions.getEntrypoint());
            containerConfigBuilder.cmd(templateOptions.getCommands());
            containerConfigBuilder.memory(templateOptions.getMemory());
            containerConfigBuilder.hostname(templateOptions.getHostname());
            containerConfigBuilder.cpuShares(templateOptions.getCpuShares());
            containerConfigBuilder.openStdin(templateOptions.getOpenStdin());
            containerConfigBuilder.env(templateOptions.getEnv());
            if (!templateOptions.getVolumes().isEmpty()) {
                LinkedHashMap volumes = Maps.newLinkedHashMap();
                for (String string : templateOptions.getVolumes().values()) {
                    volumes.put(string, Maps.newHashMap());
                }
                containerConfigBuilder.volumes(volumes);
            }
            HostConfig.Builder hostConfigBuilder = HostConfig.builder().publishAllPorts(true).privileged(templateOptions.getPrivileged());
            if (!templateOptions.getPortBindings().isEmpty()) {
                HashMap<String, List<Map<String, String>>> portBindings = Maps.newHashMap();
                for (Map.Entry<Integer, Integer> entry : templateOptions.getPortBindings().entrySet()) {
                    portBindings.put(entry.getValue() + "/tcp", Lists.newArrayList(ImmutableMap.of("HostIp", "0.0.0.0", "HostPort", Integer.toString(entry.getKey()))));
                }
                hostConfigBuilder.portBindings(portBindings);
            }
            if (!templateOptions.getDns().isEmpty()) {
                hostConfigBuilder.dns(templateOptions.getDns());
            }
            if (!templateOptions.getExtraHosts().isEmpty()) {
                ArrayList<String> extraHosts = Lists.newArrayList();
                for (Map.Entry<String, String> entry : templateOptions.getExtraHosts().entrySet()) {
                    extraHosts.add(entry.getKey() + ":" + entry.getValue());
                }
                hostConfigBuilder.extraHosts(extraHosts);
            }
            if (!templateOptions.getVolumes().isEmpty()) {
                ArrayList<String> binds = Lists.newArrayList();
                for (Map.Entry<String, String> entry : templateOptions.getVolumes().entrySet()) {
                    binds.add(entry.getKey() + ":" + entry.getValue());
                }
                hostConfigBuilder.binds(ImmutableList.copyOf(binds));
            }
            if (!templateOptions.getVolumesFrom().isEmpty()) {
                hostConfigBuilder.volumesFrom(templateOptions.getVolumesFrom());
            }
            hostConfigBuilder.networkMode(templateOptions.getNetworkMode());
            containerConfigBuilder.hostConfig(hostConfigBuilder.build());
            containerConfig = containerConfigBuilder.build();
            HashMap exposedPorts = Maps.newHashMap();
            if (containerConfig.exposedPorts() == null) {
                exposedPorts.putAll(containerConfig.exposedPorts());
            }
            for (int inboundPort : templateOptions.getInboundPorts()) {
                String portKey = inboundPort + "/tcp";
                if (exposedPorts.containsKey(portKey)) continue;
                exposedPorts.put(portKey, Maps.newHashMap());
            }
            containerConfigBuilder.exposedPorts(exposedPorts);
            containerConfig = containerConfigBuilder.build();
            HashMap<String, List<Map<String, String>>> hashMap = Maps.newHashMap();
            Map<String, List<Map<String, String>>> map = containerConfig.hostConfig().portBindings();
            if (map != null) {
                hashMap.putAll(map);
            }
            for (String exposedPort : containerConfig.exposedPorts().keySet()) {
                if (hashMap.containsKey(exposedPort)) continue;
                hashMap.put(exposedPort, Lists.newArrayList(ImmutableMap.of("HostIp", "0.0.0.0")));
            }
            hostConfigBuilder = HostConfig.builder().fromHostConfig(containerConfig.hostConfig());
            hostConfigBuilder.portBindings(hashMap);
            containerConfigBuilder.hostConfig(hostConfigBuilder.build());
        } else {
            containerConfigBuilder.image(imageId);
        }
        containerConfig = containerConfigBuilder.build();
        this.logger.debug(">> creating new container with containerConfig(%s)", containerConfig);
        Container container = this.api.getContainerApi().createContainer(name, containerConfig);
        this.logger.trace("<< container(%s)", container.id());
        if (templateOptions.getNetworks() != null) {
            this.logger.debug(">> connecting container(%s) to networks(%s)", container.id(), Iterables.toString(templateOptions.getNetworks()));
            for (String string : templateOptions.getNetworks()) {
                this.api.getNetworkApi().connectContainerToNetwork(string, container.id());
            }
            this.logger.trace("<< connected(%s)", container.id());
        }
        HostConfig hostConfig = containerConfig.hostConfig();
        this.logger.debug(">> starting container(%s) with hostConfig(%s)", container.id(), hostConfig);
        this.api.getContainerApi().startContainer(container.id(), hostConfig);
        this.logger.trace("<< started(%s)", container.id());
        container = this.api.getContainerApi().inspectContainer(container.id());
        return new ComputeServiceAdapter.NodeAndInitialCredentials<Container>(container, container.id(), LoginCredentials.builder().user(loginUser).password(loginUserPassword).build());
    }

    @Override
    public Iterable<Hardware> listHardwareProfiles() {
        LinkedHashSet<Hardware> hardware = Sets.newLinkedHashSet();
        hardware.add(new HardwareBuilder().ids("micro").hypervisor("lxc").name("micro").processor(new Processor(1.0, 1.0)).ram(512).build());
        hardware.add(new HardwareBuilder().ids("small").hypervisor("lxc").name("small").processor(new Processor(1.0, 1.0)).ram(1024).build());
        hardware.add(new HardwareBuilder().ids("medium").hypervisor("lxc").name("medium").processor(new Processor(2.0, 1.0)).ram(2048).build());
        hardware.add(new HardwareBuilder().ids("large").hypervisor("lxc").name("large").processor(new Processor(2.0, 1.0)).ram(3072).build());
        return hardware;
    }

    @Override
    public Set<Image> listImages() {
        HashSet<Image> images = Sets.newHashSet();
        for (ImageSummary imageSummary : this.api.getImageApi().listImages()) {
            Image inspected = this.api.getImageApi().inspectImage(imageSummary.id());
            inspected = Image.create(inspected.id(), inspected.author(), inspected.comment(), inspected.config(), inspected.containerConfig(), inspected.parent(), inspected.created(), inspected.container(), inspected.dockerVersion(), inspected.architecture(), inspected.os(), inspected.size(), inspected.virtualSize(), imageSummary.repoTags());
            images.add(inspected);
        }
        return images;
    }

    @Override
    public Image getImage(final String imageIdOrName) {
        Preconditions.checkNotNull(imageIdOrName);
        if (imageIdOrName.startsWith("sha256")) {
            return Iterables.find(this.listImages(), new Predicate<Image>(){

                @Override
                public boolean apply(Image input) {
                    return input.id().equals(imageIdOrName);
                }
            }, null);
        }
        this.api.getImageApi().createImage(CreateImageOptions.Builder.fromImage(imageIdOrName));
        return Iterables.find(this.listImages(), DockerComputeServiceAdapter.createPredicateMatchingRepoTags(imageIdOrName), null);
    }

    @Override
    public Iterable<Container> listNodes() {
        HashSet<Container> containers = Sets.newHashSet();
        for (ContainerSummary containerSummary : this.api.getContainerApi().listContainers(ListContainerOptions.Builder.all(true))) {
            containers.add(this.api.getContainerApi().inspectContainer(containerSummary.id()));
        }
        return containers;
    }

    @Override
    public Iterable<Container> listNodesByIds(Iterable<String> ids) {
        HashSet<Container> containers = Sets.newHashSet();
        for (String id : ids) {
            containers.add(this.api.getContainerApi().inspectContainer(id));
        }
        return containers;
    }

    @Override
    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    @Override
    public Container getNode(String id) {
        return this.api.getContainerApi().inspectContainer(id);
    }

    @Override
    public void destroyNode(String id) {
        this.traceContainerLogs(id);
        this.api.getContainerApi().removeContainer(id, RemoveContainerOptions.Builder.force(true));
    }

    @Override
    public void rebootNode(String id) {
        this.api.getContainerApi().stopContainer(id);
        this.api.getContainerApi().startContainer(id);
    }

    @Override
    public void resumeNode(String id) {
        this.api.getContainerApi().unpause(id);
    }

    @Override
    public void suspendNode(String id) {
        this.api.getContainerApi().pause(id);
    }

    protected static Predicate<Image> createPredicateMatchingRepoTags(String imageIdOrName) {
        final Pattern imgPattern = Pattern.compile(PATTERN_IMAGE_PREFIX + Pattern.quote(imageIdOrName) + PATTERN_IMAGE_SUFFIX);
        return new Predicate<Image>(){

            @Override
            public boolean apply(Image input) {
                for (String tag : input.repoTags()) {
                    if (!imgPattern.matcher(tag).matches()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceContainerLogs(String containerId) {
        if (this.logger.isTraceEnabled()) {
            DockerInputStream dis = null;
            try {
                dis = new DockerInputStream(this.api.getContainerApi().attach(containerId, AttachOptions.Builder.logs(true).stderr(true).stdout(true)));
                String idToLog = containerId;
                if (idToLog.length() > 8) {
                    idToLog = idToLog.substring(0, 8);
                }
                StdStreamData data = null;
                block8: while (null != (data = dis.readStdStreamData())) {
                    byte[] bytePayload = data.getPayload();
                    String payload = bytePayload != null ? new String(bytePayload, Charsets.UTF_8) : "";
                    switch (data.getType()) {
                        case OUT: {
                            this.logger.trace("Container [%s] StdOut: %s", idToLog, payload);
                            continue block8;
                        }
                        case ERR: {
                            this.logger.trace("Container [%s] StdErr: %s", idToLog, payload);
                            continue block8;
                        }
                    }
                    this.logger.trace("Container [%s] - Unexpected STD stream type: %s", new Object[]{idToLog, data.getType()});
                }
            }
            catch (Exception e) {
                try {
                    this.logger.trace("Retrieving container log failed", e);
                }
                catch (Throwable throwable) {
                    Closeables2.closeQuietly(dis);
                    throw throwable;
                }
                Closeables2.closeQuietly(dis);
            }
            Closeables2.closeQuietly(dis);
        }
    }
}

