/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.DateUtils;

public class SimpleDateFormatDateService
implements DateService {
    private static final SimpleDateFormat iso8601SecondsSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
    private static final SimpleDateFormat iso8601SimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
    private static final SimpleDateFormat rfc822SimpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    private static final SimpleDateFormat rfc1123SimpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
    private static final SimpleDateFormat cSimpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.US);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String cDateFormat(Date date) {
        SimpleDateFormat simpleDateFormat = cSimpleDateFormat;
        synchronized (simpleDateFormat) {
            return cSimpleDateFormat.format(date);
        }
    }

    @Override
    public final String cDateFormat() {
        return this.cDateFormat(new Date());
    }

    @Override
    public final Date cDateParse(String toParse) {
        SimpleDateFormat simpleDateFormat = cSimpleDateFormat;
        synchronized (simpleDateFormat) {
            try {
                return cSimpleDateFormat.parse(toParse);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Error parsing data at " + pe.getErrorOffset(), pe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String rfc822DateFormat(Date date) {
        SimpleDateFormat simpleDateFormat = rfc822SimpleDateFormat;
        synchronized (simpleDateFormat) {
            return rfc822SimpleDateFormat.format(date);
        }
    }

    @Override
    public final String rfc822DateFormat() {
        return this.rfc822DateFormat(new Date());
    }

    @Override
    public final Date rfc822DateParse(String toParse) {
        SimpleDateFormat simpleDateFormat = rfc822SimpleDateFormat;
        synchronized (simpleDateFormat) {
            try {
                return rfc822SimpleDateFormat.parse(toParse);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Error parsing data at " + pe.getErrorOffset(), pe);
            }
        }
    }

    @Override
    public final String iso8601SecondsDateFormat() {
        return this.iso8601SecondsDateFormat(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String iso8601DateFormat(Date date) {
        SimpleDateFormat simpleDateFormat = iso8601SimpleDateFormat;
        synchronized (simpleDateFormat) {
            String parsed = iso8601SimpleDateFormat.format(date);
            String tz = DateUtils.findTZ(parsed);
            if (tz.equals("+0000")) {
                parsed = DateUtils.trimTZ(parsed) + "Z";
            }
            return parsed;
        }
    }

    @Override
    public final String iso8601DateFormat() {
        return this.iso8601DateFormat(new Date());
    }

    @Override
    public final Date iso8601DateParse(String toParse) {
        if (toParse.length() < 10) {
            throw new IllegalArgumentException("incorrect date format " + toParse);
        }
        String tz = DateUtils.findTZ(toParse);
        toParse = DateUtils.trimToMillis(toParse);
        toParse = DateUtils.trimTZ(toParse);
        if ((toParse = toParse + tz).charAt(10) == ' ') {
            toParse = new StringBuilder(toParse).replace(10, 11, "T").toString();
        }
        SimpleDateFormat simpleDateFormat = iso8601SimpleDateFormat;
        synchronized (simpleDateFormat) {
            try {
                return iso8601SimpleDateFormat.parse(toParse);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Error parsing data at " + pe.getErrorOffset(), pe);
            }
        }
    }

    @Override
    public final Date iso8601SecondsDateParse(String toParse) throws IllegalArgumentException {
        if (toParse.length() < 10) {
            throw new IllegalArgumentException("incorrect date format " + toParse);
        }
        String tz = DateUtils.findTZ(toParse);
        toParse = DateUtils.trimToMillis(toParse);
        toParse = DateUtils.trimTZ(toParse);
        if ((toParse = toParse + tz).charAt(10) == ' ') {
            toParse = new StringBuilder(toParse).replace(10, 11, "T").toString();
        }
        SimpleDateFormat simpleDateFormat = iso8601SecondsSimpleDateFormat;
        synchronized (simpleDateFormat) {
            try {
                return iso8601SecondsSimpleDateFormat.parse(toParse);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Error parsing data at " + pe.getErrorOffset(), pe);
            }
        }
    }

    @Override
    public Date iso8601DateOrSecondsDateParse(String toParse) throws IllegalArgumentException {
        try {
            return this.iso8601DateParse(toParse);
        }
        catch (IllegalArgumentException orig) {
            try {
                return this.iso8601SecondsDateParse(toParse);
            }
            catch (IllegalArgumentException ignored2) {
                throw orig;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String iso8601SecondsDateFormat(Date date) {
        SimpleDateFormat simpleDateFormat = iso8601SecondsSimpleDateFormat;
        synchronized (simpleDateFormat) {
            String parsed = iso8601SecondsSimpleDateFormat.format(date);
            String tz = DateUtils.findTZ(parsed);
            if (tz.equals("+0000")) {
                parsed = DateUtils.trimTZ(parsed) + "Z";
            }
            return parsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String rfc1123DateFormat(Date date) {
        SimpleDateFormat simpleDateFormat = rfc1123SimpleDateFormat;
        synchronized (simpleDateFormat) {
            return rfc1123SimpleDateFormat.format(date);
        }
    }

    @Override
    public final String rfc1123DateFormat() {
        return this.rfc1123DateFormat(new Date());
    }

    @Override
    public final Date rfc1123DateParse(String toParse) throws IllegalArgumentException {
        SimpleDateFormat simpleDateFormat = rfc1123SimpleDateFormat;
        synchronized (simpleDateFormat) {
            try {
                return rfc1123SimpleDateFormat.parse(toParse);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Error parsing data at " + pe.getErrorOffset(), pe);
            }
        }
    }

    static {
        iso8601SimpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        iso8601SecondsSimpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        rfc822SimpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        cSimpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }
}

