/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Alarm;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListAlarmsOptions
extends BaseHttpRequestOptions {
    int alarmIndex = 1;

    public ListAlarmsOptions actionPrefix(String actionPrefix) {
        Preconditions.checkNotNull(actionPrefix, "actionPrefix");
        Preconditions.checkArgument(actionPrefix.length() <= 1024, "actionPrefix must be between 1 and 1024 characters in length");
        this.formParameters.put("ActionPrefix", actionPrefix);
        return this;
    }

    public ListAlarmsOptions alarmNamePrefix(String alarmNamePrefix) {
        Preconditions.checkNotNull(alarmNamePrefix, "alarmNamePrefix");
        Preconditions.checkArgument(alarmNamePrefix.length() <= 255, "actionPrefix must be between 1 and 255 characters in length");
        this.formParameters.put("AlarmNamePrefix", alarmNamePrefix);
        return this;
    }

    public ListAlarmsOptions alarmNames(Set<String> alarmNames) {
        for (String alarmName : Preconditions.checkNotNull(alarmNames, "alarmNames")) {
            this.alarmName(alarmName);
        }
        return this;
    }

    public ListAlarmsOptions alarmName(String alarmName) {
        Preconditions.checkArgument(this.alarmIndex <= 100, "maximum number of alarm names is 100");
        this.formParameters.put("AlarmNames.member." + this.alarmIndex, Preconditions.checkNotNull(alarmName, "alarmName"));
        ++this.alarmIndex;
        return this;
    }

    public ListAlarmsOptions maxRecords(int maxRecords) {
        this.formParameters.put("MaxRecords", String.valueOf(maxRecords));
        return this;
    }

    public ListAlarmsOptions state(Alarm.State state) {
        Preconditions.checkNotNull(state, "state");
        Preconditions.checkArgument(state != Alarm.State.UNRECOGNIZED, "state unrecognized");
        this.formParameters.put("StateValue", state.toString());
        return this;
    }
}

