/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;

public enum Unit {
    SECONDS,
    MICROSECONDS,
    MILLISECONDS,
    BYTES,
    KILOBYTES,
    MEGABYTES,
    GIGABYTES,
    TERABYTES,
    BITS,
    KILOBITS,
    MEGABITS,
    GIGABITS,
    TERABITS,
    PERCENT,
    COUNT,
    BYTES_PER_SECOND,
    KILOBYTES_PER_SECOND,
    MEGABYTES_PER_SECOND,
    GIGABYTES_PER_SECOND,
    TERABYTES_PER_SECOND,
    BITS_PER_SECOND,
    KILOBITS_PER_SECOND,
    MEGABITS_PER_SECOND,
    GIGABITS_PER_SECOND,
    TERABITS_PER_SECOND,
    COUNT_PER_SECOND,
    NONE,
    UNRECOGNIZED;


    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name()).replace("PerSecond", "/Second");
    }

    public String toString() {
        return this.value();
    }

    public static Unit fromValue(String value) {
        try {
            return Unit.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(value, "value").replace("/", "Per")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

