/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;

@Beta
public enum HistoryItemType {
    CONFIGURATION_UPDATE,
    STATE_UPDATE,
    ACTION,
    UNRECOGNIZED;


    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
    }

    public String toString() {
        return this.value();
    }

    public static HistoryItemType fromValue(String value) {
        try {
            return HistoryItemType.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(value, "value")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

