/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Set;
import org.jclouds.cloudstack.domain.IngressRule;
import org.jclouds.cloudstack.domain.SecurityGroup;

public class SecurityGroupPredicates {
    public static Predicate<SecurityGroup> portInRange(final int port) {
        return new Predicate<SecurityGroup>(){

            @Override
            public boolean apply(SecurityGroup group) {
                return Iterables.any(group.getIngressRules(), new Predicate<IngressRule>(){

                    @Override
                    public boolean apply(IngressRule rule) {
                        return rule.getStartPort() <= port && rule.getEndPort() >= port;
                    }
                });
            }

            public String toString() {
                return "portInRange(" + port + ")";
            }
        };
    }

    public static Predicate<SecurityGroup> hasCidr(final String cidr) {
        return new Predicate<SecurityGroup>(){

            @Override
            public boolean apply(SecurityGroup group) {
                return Iterables.any(group.getIngressRules(), new Predicate<IngressRule>(){

                    @Override
                    public boolean apply(IngressRule rule) {
                        return rule.getCIDR() != null && rule.getCIDR().equals(cidr);
                    }
                });
            }

            public String toString() {
                return "hasCidr(" + cidr + ")";
            }
        };
    }

    public static Predicate<SecurityGroup> portInRangeForCidr(final int port, final String cidr) {
        return new Predicate<SecurityGroup>(){

            @Override
            public boolean apply(SecurityGroup group) {
                return Iterables.any(group.getIngressRules(), new Predicate<IngressRule>(){

                    @Override
                    public boolean apply(IngressRule rule) {
                        return rule.getCIDR() != null && rule.getCIDR().equals(cidr) && rule.getStartPort() <= port && rule.getEndPort() >= port;
                    }
                });
            }

            public String toString() {
                return "portInRangeForCidr(" + port + ", " + cidr + ")";
            }
        };
    }

    public static Predicate<SecurityGroup> any() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<SecurityGroup> nameEquals(final String name) {
        Preconditions.checkNotNull(name, "name must be defined");
        return new Predicate<SecurityGroup>(){

            @Override
            public boolean apply(SecurityGroup ext) {
                return name.equals(ext.getName());
            }

            public String toString() {
                return "nameEquals(" + name + ")";
            }
        };
    }

    public static Predicate<SecurityGroup> nameMatches(final Predicate<String> name) {
        Preconditions.checkNotNull(name, "name must be defined");
        return new Predicate<SecurityGroup>(){

            @Override
            public boolean apply(SecurityGroup ext) {
                return name.apply(ext.getName());
            }

            public String toString() {
                return "nameMatches(" + name + ")";
            }
        };
    }

    public static Predicate<IngressRule> ruleCidrMatches(final String protocol, final int startPort, final int endPort, final Set<String> cidrs) {
        Preconditions.checkNotNull(protocol, "protocol");
        Preconditions.checkNotNull(cidrs, "cidrs");
        return new Predicate<IngressRule>(){

            @Override
            public boolean apply(IngressRule rule) {
                return protocol.equals(rule.getProtocol()) && startPort == rule.getStartPort() && endPort == rule.getEndPort() && cidrs.contains(rule.getCIDR());
            }

            public String toString() {
                return "ruleCidrMatches(protocol:" + protocol + ",startPort:" + startPort + ",endPort:" + endPort + ",cidrs:[" + cidrs + "])";
            }
        };
    }

    public static Predicate<IngressRule> ruleGroupMatches(final String protocol, final int startPort, final int endPort, final Multimap<String, String> accountGroupNames) {
        Preconditions.checkNotNull(protocol, "protocol");
        Preconditions.checkNotNull(accountGroupNames, "accountGroupNames");
        return new Predicate<IngressRule>(){

            @Override
            public boolean apply(IngressRule rule) {
                return protocol.equals(rule.getProtocol()) && startPort == rule.getStartPort() && endPort == rule.getEndPort() && accountGroupNames.containsEntry(rule.getAccount(), rule.getSecurityGroupName());
            }

            public String toString() {
                return "ruleGroupMatches(protocol:" + protocol + ",startPort:" + startPort + ",endPort:" + endPort + ",accountGroupNames:[" + accountGroupNames + "])";
            }
        };
    }
}

