/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListProjectsOptions
extends AccountInDomainOptions {
    public static final ListProjectsOptions NONE = new ListProjectsOptions();

    public ListProjectsOptions id(String id) {
        this.queryParameters.replaceValues("id", ImmutableSet.of(id));
        return this;
    }

    public ListProjectsOptions name(String name) {
        this.queryParameters.replaceValues("name", ImmutableSet.of(name));
        return this;
    }

    public ListProjectsOptions state(String state) {
        this.queryParameters.replaceValues("state", ImmutableSet.of(state));
        return this;
    }

    public ListProjectsOptions displayText(String displayText) {
        this.queryParameters.replaceValues("displaytext", ImmutableSet.of(displayText));
        return this;
    }

    public ListProjectsOptions keyword(String keyword) {
        this.queryParameters.replaceValues("keyword", ImmutableSet.of(keyword));
        return this;
    }

    public ListProjectsOptions recursive(boolean recursive) {
        this.queryParameters.replaceValues("isrecursive", ImmutableSet.of(recursive + ""));
        return this;
    }

    public ListProjectsOptions tags(Map<String, String> tags) {
        int count = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.queryParameters.replaceValues(String.format("tags[%d].key", count), ImmutableSet.of(entry.getKey()));
            this.queryParameters.replaceValues(String.format("tags[%d].value", count), ImmutableSet.of(entry.getValue()));
            ++count;
        }
        return this;
    }

    public ListProjectsOptions page(Long page) {
        this.queryParameters.replaceValues("page", ImmutableSet.of(page + ""));
        return this;
    }

    public ListProjectsOptions pageSize(Long pageSize) {
        this.queryParameters.replaceValues("pagesize", ImmutableSet.of(pageSize + ""));
        return this;
    }

    @Override
    public ListProjectsOptions accountInDomain(String account, String domain) {
        return (ListProjectsOptions)ListProjectsOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public ListProjectsOptions domainId(String domainId) {
        return (ListProjectsOptions)ListProjectsOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static ListProjectsOptions accountInDomain(String project, String domain) {
            ListProjectsOptions options = new ListProjectsOptions();
            return options.accountInDomain(project, domain);
        }

        public static ListProjectsOptions domainId(String domainId) {
            ListProjectsOptions options = new ListProjectsOptions();
            return options.domainId(domainId);
        }

        public static ListProjectsOptions id(String id) {
            ListProjectsOptions options = new ListProjectsOptions();
            return options.id(id);
        }

        public static ListProjectsOptions name(String name) {
            ListProjectsOptions options = new ListProjectsOptions();
            return options.name(name);
        }

        public static ListProjectsOptions state(String state) {
            ListProjectsOptions options = new ListProjectsOptions();
            return options.state(state);
        }

        public static ListProjectsOptions displayText(String displayText) {
            ListProjectsOptions options = new ListProjectsOptions();
            return options.displayText(displayText);
        }

        public static ListProjectsOptions keyword(String keyword) {
            ListProjectsOptions options = new ListProjectsOptions();
            return options.keyword(keyword);
        }

        public static ListProjectsOptions recursive(boolean recursive) {
            ListProjectsOptions options = new ListProjectsOptions();
            return options.recursive(recursive);
        }

        public static ListProjectsOptions tags(Map<String, String> tags) {
            ListProjectsOptions options = new ListProjectsOptions();
            return options.tags(tags);
        }

        public static ListProjectsOptions page(Long page) {
            ListProjectsOptions options = new ListProjectsOptions();
            return options.page(page);
        }

        public static ListProjectsOptions pageSize(Long pageSize) {
            ListProjectsOptions options = new ListProjectsOptions();
            return options.pageSize(pageSize);
        }
    }
}

