/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;

public class StoragePool
implements Comparable<StoragePool> {
    private final String id;
    private final String name;
    private final String path;
    private final Set<String> tags;
    private final State state;
    private final Type type;
    private final String zoneId;
    private final String zoneName;
    private final String podId;
    private final String podName;
    private final String clusterId;
    private final String clusterName;
    private final Date created;
    private final long diskSizeAllocated;
    private final long diskSizeTotal;
    private final String ipAddress;
    private final String jobId;
    private final String jobStatus;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromStoragePool(this);
    }

    @ConstructorProperties(value={"id", "name", "path", "tags", "state", "type", "zoneid", "zonename", "podid", "podname", "clusterid", "clustername", "created", "disksizeallocated", "disksizetotal", "ipaddress", "jobid", "jobstatus"})
    protected StoragePool(String id, @Nullable String name, @Nullable String path, @Nullable Iterable<String> tags, @Nullable State state, @Nullable Type type, @Nullable String zoneId, @Nullable String zoneName, @Nullable String podId, @Nullable String podName, @Nullable String clusterId, @Nullable String clusterName, @Nullable Date created, long diskSizeAllocated, long diskSizeTotal, @Nullable String ipAddress, @Nullable String jobId, @Nullable String jobStatus) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = name;
        this.path = path;
        this.tags = tags != null ? ImmutableSet.copyOf(tags) : ImmutableSet.of();
        this.state = state;
        this.type = type;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.podId = podId;
        this.podName = podName;
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.created = created;
        this.diskSizeAllocated = diskSizeAllocated;
        this.diskSizeTotal = diskSizeTotal;
        this.ipAddress = ipAddress;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getZoneName() {
        return this.zoneName;
    }

    @Nullable
    public String getPodId() {
        return this.podId;
    }

    @Nullable
    public String getPodName() {
        return this.podName;
    }

    @Nullable
    public String getClusterId() {
        return this.clusterId;
    }

    @Nullable
    public String getClusterName() {
        return this.clusterName;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    public long getDiskSizeAllocated() {
        return this.diskSizeAllocated;
    }

    public long getDiskSizeTotal() {
        return this.diskSizeTotal;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public String getJobStatus() {
        return this.jobStatus;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.name, this.path, this.tags, this.state, this.type, this.zoneId, this.zoneName, this.podId, this.podName, this.clusterId, this.clusterName, this.created, this.diskSizeAllocated, this.diskSizeTotal, this.ipAddress, this.jobId, this.jobStatus});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StoragePool that = (StoragePool)StoragePool.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.path, that.path) && Objects.equal(this.tags, that.tags) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.zoneId, that.zoneId) && Objects.equal(this.zoneName, that.zoneName) && Objects.equal(this.podId, that.podId) && Objects.equal(this.podName, that.podName) && Objects.equal(this.clusterId, that.clusterId) && Objects.equal(this.clusterName, that.clusterName) && Objects.equal(this.created, that.created) && Objects.equal(this.diskSizeAllocated, that.diskSizeAllocated) && Objects.equal(this.diskSizeTotal, that.diskSizeTotal) && Objects.equal(this.ipAddress, that.ipAddress) && Objects.equal(this.jobId, that.jobId) && Objects.equal(this.jobStatus, that.jobStatus);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.name).add("path", this.path).add("tags", this.tags).add("state", (Object)this.state).add("type", (Object)this.type).add("zoneId", this.zoneId).add("zoneName", this.zoneName).add("podId", this.podId).add("podName", this.podName).add("clusterId", this.clusterId).add("clusterName", this.clusterName).add("created", this.created).add("diskSizeAllocated", this.diskSizeAllocated).add("diskSizeTotal", this.diskSizeTotal).add("ipAddress", this.ipAddress).add("jobId", this.jobId).add("jobStatus", this.jobStatus);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(StoragePool other) {
        return this.id.compareTo(other.id);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected String path;
        protected ImmutableSet.Builder<String> tags = ImmutableSet.builder();
        protected State state;
        protected Type type;
        protected String zoneId;
        protected String zoneName;
        protected String podId;
        protected String podName;
        protected String clusterId;
        protected String clusterName;
        protected Date created;
        protected long diskSizeAllocated;
        protected long diskSizeTotal;
        protected String ipAddress;
        protected String jobId;
        protected String jobStatus;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T path(String path) {
            this.path = path;
            return this.self();
        }

        public T tags(Iterable<String> tags) {
            this.tags = ImmutableSet.builder().addAll(tags);
            return this.self();
        }

        public T tag(String tag) {
            this.tags.add((Object)tag);
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T type(Type type) {
            this.type = type;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this.self();
        }

        public T podId(String podId) {
            this.podId = podId;
            return this.self();
        }

        public T podName(String podName) {
            this.podName = podName;
            return this.self();
        }

        public T clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this.self();
        }

        public T clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T diskSizeAllocated(long diskSizeAllocated) {
            this.diskSizeAllocated = diskSizeAllocated;
            return this.self();
        }

        public T diskSizeTotal(long diskSizeTotal) {
            this.diskSizeTotal = diskSizeTotal;
            return this.self();
        }

        public T ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this.self();
        }

        public T jobId(String jobId) {
            this.jobId = jobId;
            return this.self();
        }

        public T jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this.self();
        }

        public StoragePool build() {
            return new StoragePool(this.id, this.name, this.path, this.tags.build(), this.state, this.type, this.zoneId, this.zoneName, this.podId, this.podName, this.clusterId, this.clusterName, this.created, this.diskSizeAllocated, this.diskSizeTotal, this.ipAddress, this.jobId, this.jobStatus);
        }

        public T fromStoragePool(StoragePool in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).path(in.getPath())).tags(in.getTags())).state(in.getState())).type(in.getType())).zoneId(in.getZoneId())).zoneName(in.getZoneName())).podId(in.getPodId())).podName(in.getPodName())).clusterId(in.getClusterId())).clusterName(in.getClusterName())).created(in.getCreated())).diskSizeAllocated(in.getDiskSizeAllocated())).diskSizeTotal(in.getDiskSizeTotal())).ipAddress(in.getIpAddress())).jobId(in.getJobId())).jobStatus(in.getJobStatus());
        }
    }

    public static enum Type {
        FILESYSTEM,
        NETWORK_FILESYSTEM,
        ISCSI_LUN,
        ISCSI,
        ISO,
        LVM,
        CLVM,
        SHARED_MOUNT_POINT,
        VMFS,
        PRE_SETUP,
        EXT,
        OCFS2,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static Type fromValue(String type) {
            try {
                return Type.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(type, "type")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum State {
        UP,
        PREPARE_FOR_MAINTENANCE,
        ERROR_IN_MAINTENANCE,
        CANCEL_MAINTENANCE,
        MAINTENANCE,
        REMOVED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String type) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(type, "type")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

