/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;

public class NetworkService
implements Comparable<NetworkService> {
    private final String name;
    private final Set<Capability> capabilities;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromNetworkService(this);
    }

    @ConstructorProperties(value={"name", "capability"})
    protected NetworkService(String name, @Nullable Set<Capability> capabilities) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.capabilities = capabilities == null ? ImmutableSet.of() : ImmutableSortedSet.copyOf(capabilities);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getCapabilities() {
        ImmutableSortedMap.Builder returnVal = ImmutableSortedMap.naturalOrder();
        for (Capability capability : this.capabilities) {
            returnVal.put(capability.name, capability.value);
        }
        return returnVal.build();
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.capabilities);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkService that = (NetworkService)NetworkService.class.cast(obj);
        return Objects.equal(this.name, that.name) && Objects.equal(this.capabilities, that.capabilities);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("capabilities", this.capabilities);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(NetworkService o) {
        return this.name.compareTo(o.getName());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected Set<Capability> capabilities = Sets.newHashSet();

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T capabilities(Map<String, String> capabilities) {
            for (Map.Entry<String, String> entry : capabilities.entrySet()) {
                this.capabilities.add(((Capability.Builder)((Capability.Builder)Capability.builder().name(entry.getKey())).value(entry.getValue())).build());
            }
            return this.self();
        }

        public NetworkService build() {
            return new NetworkService(this.name, this.capabilities);
        }

        public T fromNetworkService(NetworkService in) {
            return ((Builder)this.name(in.getName())).capabilities(in.getCapabilities());
        }
    }

    public static class Capability
    implements Comparable<Capability> {
        private final String name;
        private final String value;

        public static Builder<?> builder() {
            return new ConcreteBuilder();
        }

        public Builder<?> toBuilder() {
            return new ConcreteBuilder().fromCapability(this);
        }

        @ConstructorProperties(value={"name", "value"})
        protected Capability(String name, @Nullable String value) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hashCode(this.name, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Capability that = (Capability)Capability.class.cast(obj);
            return Objects.equal(this.name, that.name) && Objects.equal(this.value, that.value);
        }

        protected MoreObjects.ToStringHelper string() {
            return MoreObjects.toStringHelper(this).add("name", this.name).add("value", this.value);
        }

        public String toString() {
            return this.string().toString();
        }

        @Override
        public int compareTo(Capability o) {
            return this.name.compareTo(o.getName());
        }

        private static class ConcreteBuilder
        extends Builder<ConcreteBuilder> {
            private ConcreteBuilder() {
            }

            @Override
            protected ConcreteBuilder self() {
                return this;
            }
        }

        public static abstract class Builder<T extends Builder<T>> {
            protected String name;
            protected String value;

            protected abstract T self();

            public T name(String name) {
                this.name = name;
                return this.self();
            }

            public T value(String value) {
                this.value = value;
                return this.self();
            }

            public Capability build() {
                return new Capability(this.name, this.value);
            }

            public T fromCapability(Capability in) {
                return ((Builder)this.name(in.getName())).value(in.getValue());
            }
        }
    }
}

