/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.cloudstack.domain.AsyncJobError;
import org.jclouds.javax.annotation.Nullable;

public class AsyncJob<S> {
    private final String accountId;
    private final String cmd;
    private final Date created;
    private final String id;
    private final String instanceId;
    private final String instanceType;
    private final int progress;
    private final S result;
    private final ResultCode resultCode;
    private final String resultType;
    private final Status status;
    private final String userId;
    private final AsyncJobError error;

    public static <T> Builder<?, T> builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromAsyncJob(this);
    }

    @ConstructorProperties(value={"accountid", "cmd", "created", "jobid", "jobinstanceid", "jobinstancetype", "jobprocstatus", "jobresult", "jobresultcode", "jobresulttype", "jobstatus", "userid", "error"})
    protected AsyncJob(@Nullable String accountId, @Nullable String cmd, @Nullable Date created, String id, @Nullable String instanceId, @Nullable String instanceType, int progress, @Nullable S result, @Nullable ResultCode resultCode, @Nullable String resultType, @Nullable Status status, @Nullable String userId, @Nullable AsyncJobError error) {
        this.accountId = accountId;
        this.cmd = cmd;
        this.created = created;
        this.id = Preconditions.checkNotNull(id, "id");
        this.instanceId = instanceId;
        this.instanceType = instanceType;
        this.progress = progress;
        this.result = result;
        this.resultCode = resultCode;
        this.resultType = resultType;
        this.status = status;
        this.userId = userId;
        this.error = error;
    }

    @Nullable
    public String getAccountId() {
        return this.accountId;
    }

    @Nullable
    public String getCmd() {
        return this.cmd;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getInstanceId() {
        return this.instanceId;
    }

    @Nullable
    public String getInstanceType() {
        return this.instanceType;
    }

    public int getProgress() {
        return this.progress;
    }

    @Nullable
    public S getResult() {
        return this.result;
    }

    @Nullable
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    public String getResultType() {
        return this.resultType;
    }

    @Nullable
    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public String getUserId() {
        return this.userId;
    }

    @Nullable
    public AsyncJobError getError() {
        return this.error;
    }

    public boolean hasFailed() {
        return this.getError() != null || this.getResultCode() == ResultCode.FAIL || this.getStatus() == Status.FAILED;
    }

    public boolean hasSucceed() {
        return this.getError() == null && this.getResultCode() == ResultCode.SUCCESS && this.getStatus() == Status.SUCCEEDED;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.accountId, this.cmd, this.created, this.id, this.instanceId, this.instanceType, this.progress, this.result, this.resultCode, this.resultType, this.status, this.userId, this.error});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncJob that = (AsyncJob)AsyncJob.class.cast(obj);
        return Objects.equal(this.accountId, that.accountId) && Objects.equal(this.cmd, that.cmd) && Objects.equal(this.created, that.created) && Objects.equal(this.id, that.id) && Objects.equal(this.instanceId, that.instanceId) && Objects.equal(this.instanceType, that.instanceType) && Objects.equal(this.progress, that.progress) && Objects.equal(this.result, that.result) && Objects.equal((Object)this.resultCode, (Object)that.resultCode) && Objects.equal(this.resultType, that.resultType) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal(this.userId, that.userId) && Objects.equal(this.error, that.error);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("accountId", this.accountId).add("cmd", this.cmd).add("created", this.created).add("id", this.id).add("instanceId", this.instanceId).add("instanceType", this.instanceType).add("progress", this.progress).add("result", this.result).add("resultCode", (Object)this.resultCode).add("resultType", this.resultType).add("status", (Object)this.status).add("userId", this.userId).add("error", this.error);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder<T>
    extends Builder<ConcreteBuilder<T>, T> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder<T> self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T, S>, S> {
        protected String accountId;
        protected String cmd;
        protected Date created;
        protected String id;
        protected String instanceId;
        protected String instanceType;
        protected int progress;
        protected S result;
        protected ResultCode resultCode;
        protected String resultType;
        protected Status status;
        protected String userId;
        protected AsyncJobError error;

        protected abstract T self();

        public T accountId(String accountId) {
            this.accountId = accountId;
            return this.self();
        }

        public T cmd(String cmd) {
            this.cmd = cmd;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this.self();
        }

        public T instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this.self();
        }

        public T progress(int progress) {
            this.progress = progress;
            return this.self();
        }

        public T result(S result) {
            this.result = result;
            return this.self();
        }

        public T resultCode(ResultCode resultCode) {
            this.resultCode = resultCode;
            return this.self();
        }

        public T resultType(String resultType) {
            this.resultType = resultType;
            return this.self();
        }

        public T status(Status status) {
            this.status = status;
            return this.self();
        }

        public T userId(String userId) {
            this.userId = userId;
            return this.self();
        }

        public T error(AsyncJobError error) {
            this.error = error;
            return this.self();
        }

        public AsyncJob build() {
            return new AsyncJob<S>(this.accountId, this.cmd, this.created, this.id, this.instanceId, this.instanceType, this.progress, this.result, this.resultCode, this.resultType, this.status, this.userId, this.error);
        }

        public T fromAsyncJob(AsyncJob<S> in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.accountId(in.getAccountId())).cmd(in.getCmd())).created(in.getCreated())).id(in.getId())).instanceId(in.getInstanceId())).instanceType(in.getInstanceType())).progress(in.getProgress())).result(in.getResult())).resultCode(in.getResultCode())).resultType(in.getResultType())).status(in.getStatus())).userId(in.getUserId())).error(in.getError());
        }

        public static Builder<?, Object> fromAsyncJobUntyped(AsyncJob<?> in) {
            return new ConcreteBuilder().fromAsyncJob(in);
        }
    }

    public static enum Status {
        IN_PROGRESS(0),
        SUCCEEDED(1),
        FAILED(2),
        UNKNOWN(-1);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static Status fromValue(String value) {
            try {
                int statusCode = Integer.parseInt(value);
                switch (statusCode) {
                    case 0: {
                        return IN_PROGRESS;
                    }
                    case 1: {
                        return SUCCEEDED;
                    }
                    case 2: {
                        return FAILED;
                    }
                }
                return UNKNOWN;
            }
            catch (NumberFormatException e) {
                return UNKNOWN;
            }
        }
    }

    public static enum ResultCode {
        SUCCESS(0),
        FAIL(530),
        UNKNOWN(-1);

        private final int code;

        private ResultCode(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static ResultCode fromValue(String value) {
            try {
                int resultCode = Integer.parseInt(value);
                switch (resultCode) {
                    case 0: {
                        return SUCCESS;
                    }
                    case 530: {
                        return FAIL;
                    }
                }
                return UNKNOWN;
            }
            catch (NumberFormatException e) {
                return UNKNOWN;
            }
        }
    }
}

