/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;

public class Alert {
    private final String id;
    private final String description;
    private final Date sent;
    private final String type;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAlert(this);
    }

    @ConstructorProperties(value={"id", "description", "sent", "type"})
    protected Alert(String id, @Nullable String description, @Nullable Date sent, @Nullable String type) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.description = description;
        this.sent = sent;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Date getSent() {
        return this.sent;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.description, this.sent, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Alert that = (Alert)Alert.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.description, that.description) && Objects.equal(this.sent, that.sent) && Objects.equal(this.type, that.type);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("description", this.description).add("sent", this.sent).add("type", this.type);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String description;
        protected Date sent;
        protected String type;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T sent(Date sent) {
            this.sent = sent;
            return this.self();
        }

        public T type(String type) {
            this.type = type;
            return this.self();
        }

        public Alert build() {
            return new Alert(this.id, this.description, this.sent, this.type);
        }

        public T fromAlert(Alert in) {
            return ((Builder)((Builder)((Builder)this.id(in.getId())).description(in.getDescription())).sent(in.getSent())).type(in.getType());
        }
    }
}

