/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.compute.strategy.OptionsConverter;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.Capabilities;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.NIC;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.Project;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.ServiceOffering;
import org.jclouds.cloudstack.domain.SshKeyPair;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.domain.ZoneAndName;
import org.jclouds.cloudstack.domain.ZoneSecurityGroupNamePortsCidrs;
import org.jclouds.cloudstack.features.TemplateApi;
import org.jclouds.cloudstack.functions.CreateFirewallRulesForIP;
import org.jclouds.cloudstack.functions.CreatePortForwardingRulesForIP;
import org.jclouds.cloudstack.functions.StaticNATVirtualMachineInNetwork;
import org.jclouds.cloudstack.options.CreateTagsOptions;
import org.jclouds.cloudstack.options.DeployVirtualMachineOptions;
import org.jclouds.cloudstack.options.ListFirewallRulesOptions;
import org.jclouds.cloudstack.options.ListServiceOfferingsOptions;
import org.jclouds.cloudstack.options.ListTemplatesOptions;
import org.jclouds.cloudstack.options.ListVirtualMachinesOptions;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.cloudstack.predicates.TemplatePredicates;
import org.jclouds.cloudstack.predicates.ZonePredicates;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshKeys;

@Singleton
public class CloudStackComputeServiceAdapter
implements ComputeServiceAdapter<VirtualMachine, ServiceOffering, Template, Zone> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudStackApi client;
    private final Predicate<String> jobComplete;
    private final Supplier<Map<String, Network>> networkSupplier;
    private final Supplier<Map<String, Project>> projectSupplier;
    private final BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult;
    private final StaticNATVirtualMachineInNetwork.Factory staticNATVMInNetwork;
    private final CreatePortForwardingRulesForIP setupPortForwardingRulesForIP;
    private final CreateFirewallRulesForIP setupFirewallRulesForIP;
    private final LoadingCache<String, Set<IPForwardingRule>> vmToRules;
    private final Map<String, Credentials> credentialStore;
    private final Map<NetworkType, ? extends OptionsConverter> optionsConverters;
    private final Supplier<LoadingCache<String, Zone>> zoneIdToZone;
    private final LoadingCache<ZoneAndName, SecurityGroup> securityGroupCache;
    private final LoadingCache<String, SshKeyPair> keyPairCache;
    private final GroupNamingConvention.Factory namingConvention;
    private final GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull credentialsProvider;

    @Inject
    public CloudStackComputeServiceAdapter(CloudStackApi client, Predicate<String> jobComplete, @Memoized Supplier<Map<String, Network>> networkSupplier, @Memoized Supplier<Map<String, Project>> projectSupplier, BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult, StaticNATVirtualMachineInNetwork.Factory staticNATVMInNetwork, CreatePortForwardingRulesForIP setupPortForwardingRulesForIP, CreateFirewallRulesForIP setupFirewallRulesForIP, LoadingCache<String, Set<IPForwardingRule>> vmToRules, Map<String, Credentials> credentialStore, Map<NetworkType, ? extends OptionsConverter> optionsConverters, Supplier<LoadingCache<String, Zone>> zoneIdToZone, LoadingCache<ZoneAndName, SecurityGroup> securityGroupCache, LoadingCache<String, SshKeyPair> keyPairCache, GroupNamingConvention.Factory namingConvention, GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull credentialsProvider) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.jobComplete = Preconditions.checkNotNull(jobComplete, "jobComplete");
        this.networkSupplier = Preconditions.checkNotNull(networkSupplier, "networkSupplier");
        this.projectSupplier = Preconditions.checkNotNull(projectSupplier, "projectSupplier");
        this.blockUntilJobCompletesAndReturnResult = Preconditions.checkNotNull(blockUntilJobCompletesAndReturnResult, "blockUntilJobCompletesAndReturnResult");
        this.staticNATVMInNetwork = Preconditions.checkNotNull(staticNATVMInNetwork, "staticNATVMInNetwork");
        this.setupPortForwardingRulesForIP = Preconditions.checkNotNull(setupPortForwardingRulesForIP, "setupPortForwardingRulesForIP");
        this.setupFirewallRulesForIP = Preconditions.checkNotNull(setupFirewallRulesForIP, "setupFirewallRulesForIP");
        this.vmToRules = Preconditions.checkNotNull(vmToRules, "vmToRules");
        this.credentialStore = Preconditions.checkNotNull(credentialStore, "credentialStore");
        this.securityGroupCache = Preconditions.checkNotNull(securityGroupCache, "securityGroupCache");
        this.keyPairCache = Preconditions.checkNotNull(keyPairCache, "keyPairCache");
        this.optionsConverters = optionsConverters;
        this.zoneIdToZone = zoneIdToZone;
        this.namingConvention = namingConvention;
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<VirtualMachine> createNodeWithGroupEncodedIntoName(String group, String name, org.jclouds.compute.domain.Template template) {
        SshKeyPair keyPair;
        Preconditions.checkNotNull(template, "template was null");
        Preconditions.checkNotNull(template.getOptions(), "template options was null");
        Preconditions.checkArgument(template.getOptions().getClass().isAssignableFrom(CloudStackTemplateOptions.class), "options class %s should have been assignable from CloudStackTemplateOptions", template.getOptions().getClass());
        Map<String, Network> networks = this.networkSupplier.get();
        String zoneId = template.getLocation().getId();
        Zone zone = this.zoneIdToZone.get().getUnchecked(zoneId);
        CloudStackTemplateOptions templateOptions = template.getOptions().as(CloudStackTemplateOptions.class);
        Preconditions.checkState(this.optionsConverters.containsKey((Object)zone.getNetworkType()), "no options converter configured for network type %s", new Object[]{zone.getNetworkType()});
        DeployVirtualMachineOptions options = DeployVirtualMachineOptions.Builder.displayName(name).name(name);
        if (templateOptions.getAccount() != null) {
            options.accountInDomain(templateOptions.getAccount(), templateOptions.getDomainId());
        } else if (templateOptions.getDomainId() != null) {
            options.domainId(templateOptions.getDomainId());
        }
        OptionsConverter optionsConverter = this.optionsConverters.get((Object)zone.getNetworkType());
        options = optionsConverter.apply(templateOptions, networks, zoneId, options);
        options.group(group);
        if (templateOptions.getIpOnDefaultNetwork() != null) {
            options.ipOnDefaultNetwork(templateOptions.getIpOnDefaultNetwork());
        }
        if (!templateOptions.getIpsToNetworks().isEmpty()) {
            options.ipsToNetworks(templateOptions.getIpsToNetworks());
        }
        if (templateOptions.getUserData() != null) {
            options.userData(templateOptions.getUserData());
        }
        if (templateOptions.getKeyPair() != null) {
            keyPair = null;
            if (templateOptions.getLoginPrivateKey() != null) {
                String pem = templateOptions.getLoginPrivateKey();
                keyPair = ((SshKeyPair.Builder)((SshKeyPair.Builder)((SshKeyPair.Builder)SshKeyPair.builder().name(templateOptions.getKeyPair())).fingerprint(SshKeys.fingerprintPrivateKey(pem))).privateKey(pem)).build();
                this.keyPairCache.asMap().put(keyPair.getName(), keyPair);
                options.keyPair(keyPair.getName());
            } else if (this.client.getSSHKeyPairApi().getSSHKeyPair(templateOptions.getKeyPair()) != null) {
                keyPair = this.client.getSSHKeyPairApi().getSSHKeyPair(templateOptions.getKeyPair());
            }
            if (keyPair != null) {
                this.keyPairCache.asMap().put(keyPair.getName(), keyPair);
                options.keyPair(keyPair.getName());
            }
        } else if (templateOptions.shouldGenerateKeyPair()) {
            keyPair = this.keyPairCache.getUnchecked(this.namingConvention.create().sharedNameForGroup(group));
            this.keyPairCache.asMap().put(keyPair.getName(), keyPair);
            templateOptions.keyPair(keyPair.getName());
            options.keyPair(keyPair.getName());
        }
        if (templateOptions.getDiskOfferingId() != null) {
            options.diskOfferingId(templateOptions.getDiskOfferingId());
            if (templateOptions.getDataDiskSize() > 0) {
                options.dataDiskSize(templateOptions.getDataDiskSize());
            }
        }
        if (ZonePredicates.supportsSecurityGroups().apply(zone)) {
            List<Integer> inboundPorts = Ints.asList(templateOptions.getInboundPorts());
            if (templateOptions.getSecurityGroupIds().isEmpty() && !inboundPorts.isEmpty() && templateOptions.shouldGenerateSecurityGroup()) {
                String securityGroupName = this.namingConvention.create().sharedNameForGroup(group);
                SecurityGroup sg = this.securityGroupCache.getUnchecked(((ZoneSecurityGroupNamePortsCidrs.Builder)((ZoneSecurityGroupNamePortsCidrs.Builder)((ZoneSecurityGroupNamePortsCidrs.Builder)((ZoneSecurityGroupNamePortsCidrs.Builder)ZoneSecurityGroupNamePortsCidrs.builder().zone(zone.getId())).name(securityGroupName)).ports(ImmutableSet.copyOf(inboundPorts))).cidrs(ImmutableSet.of())).build());
                options.securityGroupId(sg.getId());
            }
        }
        String templateId = template.getImage().getId();
        String serviceOfferingId = template.getHardware().getId();
        this.logger.debug("serviceOfferingId %s, templateId %s, zoneId %s, options %s%n", serviceOfferingId, templateId, zoneId, options);
        AsyncCreateResponse job = this.client.getVirtualMachineApi().deployVirtualMachineInZone(zoneId, serviceOfferingId, templateId, options);
        VirtualMachine vm = (VirtualMachine)this.blockUntilJobCompletesAndReturnResult.apply(job);
        this.logger.debug("--- virtualmachine: %s", vm);
        LoginCredentials credentials = this.credentialsProvider.get();
        if (credentials == null || credentials.getUser() == null) {
            LoginCredentials.Builder credentialsBuilder = LoginCredentials.builder();
            if (templateOptions.getKeyPair() != null) {
                SshKeyPair keyPair2 = this.keyPairCache.getUnchecked(templateOptions.getKeyPair());
                credentialsBuilder.privateKey(keyPair2.getPrivateKey());
            } else if (vm.isPasswordEnabled()) {
                assert (vm.getPassword() != null) : vm;
                credentialsBuilder.password(vm.getPassword());
            }
            credentials = credentialsBuilder.build();
        }
        try {
            ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
            builder.putAll(template.getOptions().getUserMetadata());
            for (String tag : template.getOptions().getTags()) {
                builder.put(tag, "jclouds-empty-tag-placeholder");
            }
            ImmutableMap<String, String> common = builder.build();
            if (!common.isEmpty()) {
                this.logger.debug(">> adding tags %s to virtualmachine(%s)", common, vm.getId());
                CreateTagsOptions tagOptions = CreateTagsOptions.Builder.resourceIds(vm.getId()).resourceType(Tag.ResourceType.USER_VM).tags(common);
                AsyncCreateResponse tagJob = this.client.getTagApi().createTags(tagOptions);
                this.awaitCompletion(tagJob.getJobId());
                this.logger.debug("<< tags added", new Object[0]);
                vm = this.client.getVirtualMachineApi().getVirtualMachine(vm.getId());
            }
            if (templateOptions.shouldSetupStaticNat()) {
                Capabilities capabilities = this.client.getConfigurationApi().listCapabilities();
                NIC nic = Iterables.find(vm.getNICs(), new Predicate<NIC>(){

                    @Override
                    public boolean apply(NIC input) {
                        return input == null ? false : input.isDefault();
                    }
                });
                String networkId = nic.getNetworkId();
                this.logger.debug(">> creating static NAT for virtualMachine(%s) in network(%s)", vm.getId(), networkId);
                PublicIPAddress ip = this.staticNATVMInNetwork.create(networks.get(networkId)).apply(vm);
                this.logger.trace("<< static NATed IPAddress(%s) to virtualMachine(%s)", ip.getId(), vm.getId());
                vm = this.client.getVirtualMachineApi().getVirtualMachine(vm.getId());
                List<Integer> ports = Ints.asList(templateOptions.getInboundPorts());
                if (capabilities.getCloudStackVersion().startsWith("2")) {
                    this.logger.debug(">> setting up IP forwarding for IPAddress(%s) rules(%s)", ip.getId(), ports);
                    Set<IPForwardingRule> rules = this.setupPortForwardingRulesForIP.apply(ip, ports);
                    this.logger.trace("<< setup %d IP forwarding rules on IPAddress(%s)", rules.size(), ip.getId());
                } else {
                    this.logger.debug(">> setting up firewall rules for IPAddress(%s) rules(%s)", ip.getId(), ports);
                    Set<FirewallRule> rules = this.setupFirewallRulesForIP.apply(ip, ports);
                    this.logger.trace("<< setup %d firewall rules on IPAddress(%s)", rules.size(), ip.getId());
                }
            }
        }
        catch (RuntimeException re) {
            this.logger.error("-- exception after node has been created, trying to destroy the created virtualMachine(%s)", vm.getId());
            try {
                this.destroyNode(vm.getId());
            }
            catch (RuntimeException re2) {
                this.logger.debug("-- exception in exceptionHandler while executing destroyNode for virtualMachine(%s), ignoring and rethrowing original exception", vm.getId());
            }
            throw re;
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials<VirtualMachine>(vm, vm.getId() + "", credentials);
    }

    @Override
    public Iterable<ServiceOffering> listHardwareProfiles() {
        return this.client.getOfferingApi().listServiceOfferings(new ListServiceOfferingsOptions[0]);
    }

    @Override
    public Iterable<Template> listImages() {
        TemplateApi templateApi = this.client.getTemplateApi();
        ImmutableSet.Builder templates = ImmutableSet.builder();
        templates.addAll(templateApi.listTemplates());
        for (String project : this.projectSupplier.get().keySet()) {
            templates.addAll(templateApi.listTemplates(ListTemplatesOptions.Builder.projectId(project)));
        }
        return Iterables.filter(templates.build(), TemplatePredicates.isReady());
    }

    @Override
    public Template getImage(String id) {
        return Iterables.get(this.client.getTemplateApi().listTemplates(ListTemplatesOptions.Builder.id(id)), 0, null);
    }

    @Override
    public Iterable<VirtualMachine> listNodes() {
        return this.client.getVirtualMachineApi().listVirtualMachines(new ListVirtualMachinesOptions[0]);
    }

    @Override
    public Iterable<VirtualMachine> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), new Predicate<VirtualMachine>(){

            @Override
            public boolean apply(VirtualMachine vm) {
                return Iterables.contains(ids, vm.getId());
            }
        });
    }

    @Override
    public Iterable<Zone> listLocations() {
        return this.client.getZoneApi().listZones(new ListZonesOptions[0]);
    }

    @Override
    public VirtualMachine getNode(String id) {
        String virtualMachineId = id;
        return this.client.getVirtualMachineApi().getVirtualMachine(virtualMachineId);
    }

    @Override
    public void destroyNode(String id) {
        String virtualMachineId = id;
        Set<String> ipAddresses = this.deleteIPForwardingRulesForVMAndReturnDistinctIPs(virtualMachineId);
        ipAddresses.addAll(this.deleteFirewallRulesForVMAndReturnDistinctIPs(virtualMachineId));
        this.disableStaticNATOnIPAddresses(ipAddresses);
        this.disassociateIPAddresses(ipAddresses);
        this.destroyVirtualMachine(virtualMachineId);
        this.vmToRules.invalidate(virtualMachineId);
    }

    public void disassociateIPAddresses(Set<String> ipAddresses) {
        for (String ipAddress : ipAddresses) {
            this.logger.debug(">> disassociating IPAddress(%s)", ipAddress);
            this.client.getAddressApi().disassociateIPAddress(ipAddress);
        }
    }

    public void destroyVirtualMachine(String virtualMachineId) {
        String destroyVirtualMachine = this.client.getVirtualMachineApi().destroyVirtualMachine(virtualMachineId);
        if (destroyVirtualMachine != null) {
            this.logger.debug(">> destroying virtualMachine(%s) job(%s)", virtualMachineId, destroyVirtualMachine);
            this.awaitCompletion(destroyVirtualMachine);
        } else {
            this.logger.trace("<< virtualMachine(%s) not found", virtualMachineId);
        }
    }

    public void disableStaticNATOnIPAddresses(Set<String> ipAddresses) {
        ImmutableSet.Builder jobsToTrack = ImmutableSet.builder();
        for (String ipAddress : ipAddresses) {
            String disableStaticNAT = this.client.getNATApi().disableStaticNATOnPublicIP(ipAddress);
            if (disableStaticNAT == null) continue;
            this.logger.debug(">> disabling static NAT IPAddress(%s) job(%s)", ipAddress, disableStaticNAT);
            jobsToTrack.add(disableStaticNAT);
        }
        this.awaitCompletion(jobsToTrack.build());
    }

    public Set<String> deleteIPForwardingRulesForVMAndReturnDistinctIPs(String virtualMachineId) {
        ImmutableSet.Builder jobsToTrack = ImmutableSet.builder();
        LinkedHashSet<String> ipAddresses = Sets.newLinkedHashSet();
        Set<IPForwardingRule> forwardingRules = this.client.getNATApi().getIPForwardingRulesForVirtualMachine(virtualMachineId);
        for (IPForwardingRule rule : forwardingRules) {
            if ("Deleting".equals(rule.getState())) continue;
            ipAddresses.add(rule.getIPAddressId());
            String deleteForwardingRule = this.client.getNATApi().deleteIPForwardingRule(rule.getId());
            if (deleteForwardingRule == null) continue;
            this.logger.debug(">> deleting IPForwardingRule(%s) job(%s)", rule.getId(), deleteForwardingRule);
            jobsToTrack.add(deleteForwardingRule);
        }
        this.awaitCompletion(jobsToTrack.build());
        return ipAddresses;
    }

    public Set<String> deleteFirewallRulesForVMAndReturnDistinctIPs(String virtualMachineId) {
        LinkedHashSet<String> ipAddresses = Sets.newLinkedHashSet();
        String publicIpId = this.client.getVirtualMachineApi().getVirtualMachine(virtualMachineId).getPublicIPId();
        if (publicIpId != null) {
            Set<FirewallRule> firewallRules = this.client.getFirewallApi().listFirewallRules(ListFirewallRulesOptions.Builder.ipAddressId(this.client.getVirtualMachineApi().getVirtualMachine(virtualMachineId).getPublicIPId()));
            for (FirewallRule rule : firewallRules) {
                if (rule.getState() == FirewallRule.State.DELETING) continue;
                ipAddresses.add(rule.getIpAddressId());
                this.client.getFirewallApi().deleteFirewallRule(rule.getId());
                this.logger.debug(">> deleting FirewallRule(%s)", rule.getId());
            }
        }
        return ipAddresses;
    }

    public void awaitCompletion(Iterable<String> jobs) {
        this.logger.debug(">> awaiting completion of jobs(%s)", jobs);
        for (String job : jobs) {
            this.awaitCompletion(job);
        }
        this.logger.trace("<< completed jobs(%s)", jobs);
    }

    public void awaitCompletion(String job) {
        boolean completed = this.jobComplete.apply(job);
        this.logger.trace("<< job(%s) complete(%s)", job, completed);
    }

    @Override
    public void rebootNode(String id) {
        String virtualMachineId = id;
        String job = this.client.getVirtualMachineApi().rebootVirtualMachine(virtualMachineId);
        if (job != null) {
            this.logger.debug(">> rebooting virtualMachine(%s) job(%s)", virtualMachineId, job);
            this.awaitCompletion(job);
        }
    }

    @Override
    public void resumeNode(String id) {
        String virtualMachineId = id;
        String job = this.client.getVirtualMachineApi().startVirtualMachine(id);
        if (job != null) {
            this.logger.debug(">> starting virtualMachine(%s) job(%s)", virtualMachineId, job);
            this.awaitCompletion(job);
        }
    }

    @Override
    public void suspendNode(String id) {
        String virtualMachineId = id;
        String job = this.client.getVirtualMachineApi().stopVirtualMachine(id);
        if (job != null) {
            this.logger.debug(">> stopping virtualMachine(%s) job(%s)", virtualMachineId, job);
            this.awaitCompletion(job);
        }
    }
}

