/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.extensions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.TemplateMetadata;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Volume;
import org.jclouds.cloudstack.options.CreateTemplateOptions;
import org.jclouds.cloudstack.options.DeleteTemplateOptions;
import org.jclouds.cloudstack.options.ListVolumesOptions;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.CloneImageTemplate;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.domain.ImageTemplateBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.logging.Logger;

@Singleton
public class CloudStackImageExtension
implements ImageExtension {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudStackApi client;
    private final ListeningExecutorService userExecutor;
    private final Supplier<Set<? extends Location>> locations;
    private final Predicate<AtomicReference<Image>> imageAvailablePredicate;
    private final BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult;
    private final Predicate<String> jobComplete;

    @Inject
    public CloudStackImageExtension(CloudStackApi client, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, @Memoized Supplier<Set<? extends Location>> locations, @Named(value="jclouds.compute.timeout.image-available") Predicate<AtomicReference<Image>> imageAvailablePredicate, BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult, Predicate<String> jobComplete) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.userExecutor = Preconditions.checkNotNull(userExecutor, "userExecutor");
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.imageAvailablePredicate = Preconditions.checkNotNull(imageAvailablePredicate, "imageAvailablePredicate");
        this.blockUntilJobCompletesAndReturnResult = Preconditions.checkNotNull(blockUntilJobCompletesAndReturnResult, "blockUntilJobCompletesAndReturnResult");
        this.jobComplete = Preconditions.checkNotNull(jobComplete, "jobComplete");
    }

    @Override
    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        VirtualMachine vm = this.client.getVirtualMachineApi().getVirtualMachine(id);
        if (vm == null) {
            throw new NoSuchElementException("Cannot find vm with id: " + id);
        }
        CloneImageTemplate template = new ImageTemplateBuilder.CloneImageTemplateBuilder().nodeId(id).name(name).build();
        return template;
    }

    @Override
    public ListenableFuture<Image> createImage(ImageTemplate template) {
        Preconditions.checkState(template instanceof CloneImageTemplate, " cloudstack only currently supports creating images through cloning.");
        CloneImageTemplate cloneTemplate = (CloneImageTemplate)template;
        VirtualMachine vm = this.client.getVirtualMachineApi().getVirtualMachine(cloneTemplate.getSourceNodeId());
        String stopJob = this.client.getVirtualMachineApi().stopVirtualMachine(vm.getId());
        this.jobComplete.apply(stopJob);
        Set<Volume> volumes = this.client.getVolumeApi().listVolumes(ListVolumesOptions.Builder.virtualMachineId(vm.getId()));
        Volume volume = Iterables.getOnlyElement(volumes);
        CreateTemplateOptions options = CreateTemplateOptions.Builder.volumeId(volume.getId());
        AsyncCreateResponse templateJob = this.client.getTemplateApi().createTemplate(((TemplateMetadata.Builder)((TemplateMetadata.Builder)((TemplateMetadata.Builder)TemplateMetadata.builder().name(cloneTemplate.getName())).osTypeId(vm.getGuestOSId())).displayText(cloneTemplate.getName())).build(), options);
        Template newTemplate = (Template)this.blockUntilJobCompletesAndReturnResult.apply(templateJob);
        this.logger.info(">> Registered new template %s, waiting for it to become available.", newTemplate.getId());
        final AtomicReference<Image> image = Atomics.newReference(new ImageBuilder().location(Iterables.find((Iterable)this.locations.get(), LocationPredicates.idEquals(vm.getZoneId()))).id(newTemplate.getId()).providerId(newTemplate.getId()).description(cloneTemplate.getName()).operatingSystem(OperatingSystem.builder().description(cloneTemplate.getName()).build()).status(Image.Status.PENDING).build());
        return this.userExecutor.submit(new Callable<Image>(){

            @Override
            public Image call() throws Exception {
                if (CloudStackImageExtension.this.imageAvailablePredicate.apply(image)) {
                    return (Image)image.get();
                }
                throw new UncheckedTimeoutException("Image was not created within the time limit: " + image.get());
            }
        });
    }

    @Override
    public boolean deleteImage(String id) {
        try {
            AsyncCreateResponse deleteJob = this.client.getTemplateApi().deleteTemplate(id, new DeleteTemplateOptions[0]);
            this.jobComplete.apply(deleteJob.getJobId());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

