/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindIdListToCommaDelimitedQueryParam
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof Iterable, "this binder is only valid for Iterables!");
        Iterable numbers = (Iterable)Preconditions.checkNotNull(input, "list of Longs");
        Preconditions.checkArgument(!Iterables.isEmpty(numbers), "you must specify at least one element");
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceQueryParam("ids", Joiner.on(',').join(numbers))).build();
    }
}

