/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.strategy.DeleteAllNodesInList;
import org.jclouds.logging.Logger;

@Singleton
public class DeleteAllNodesInListImpl
implements DeleteAllNodesInList {
    protected final ChefApi api;
    protected final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    DeleteAllNodesInListImpl(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, ChefApi api) {
        this.userExecutor = Preconditions.checkNotNull(userExecutor, "userExecuor");
        this.api = Preconditions.checkNotNull(api, "api");
    }

    @Override
    public void execute(Iterable<String> names) {
        this.execute(this.userExecutor, names);
    }

    @Override
    public void execute(final ListeningExecutorService executor, Iterable<String> names) {
        ListenableFuture<List<Node>> futures = Futures.allAsList(Iterables.transform(names, new Function<String, ListenableFuture<Node>>(){

            @Override
            public ListenableFuture<Node> apply(final String input) {
                return executor.submit(new Callable<Node>(){

                    @Override
                    public Node call() throws Exception {
                        return DeleteAllNodesInListImpl.this.api.deleteNode(input);
                    }
                });
            }
        }));
        this.logger.trace(String.format("deleting nodes: %s", Joiner.on(',').join(names)), new Object[0]);
        Futures.getUnchecked(futures);
    }
}

