/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.domain.Resource;

public class CookbookVersionPredicates {
    public static Predicate<CookbookVersion> containsRecipe(String recipe) {
        return CookbookVersionPredicates.containsRecipes(Preconditions.checkNotNull(recipe, "recipe must be defined"));
    }

    public static Predicate<CookbookVersion> containsRecipes(String ... recipes) {
        Preconditions.checkNotNull(recipes, "recipes must be defined");
        final LinkedListMultimap<String, String> search = LinkedListMultimap.create();
        for (String recipe : recipes) {
            if (recipe.indexOf("::") != -1) {
                Iterable<String> nameRecipe = Splitter.on("::").split(recipe);
                search.put(Iterables.get(nameRecipe, 0), Iterables.get(nameRecipe, 1) + ".rb");
                continue;
            }
            search.put(recipe, "default.rb");
        }
        return new Predicate<CookbookVersion>(){

            @Override
            public boolean apply(final CookbookVersion cookbookVersion) {
                return search.containsKey(cookbookVersion.getCookbookName()) && Iterables.any(search.get(cookbookVersion.getCookbookName()), new Predicate<String>(){

                    @Override
                    public boolean apply(final String recipeName) {
                        return Iterables.any(cookbookVersion.getRecipes(), new Predicate<Resource>(){

                            @Override
                            public boolean apply(Resource resource) {
                                return resource.getName().equals(recipeName);
                            }
                        });
                    }
                });
            }

            public String toString() {
                return "containsRecipes(" + search + ")";
            }
        };
    }
}

